<?php get_header(); ?>
<?php get_sidebar(); ?>

	<div id="main">
	
	<?php if (have_posts()) : while (have_posts()) : the_post(); ?>
		
		<div id="post-<?php the_ID(); ?>" class="entry">
		
			<span class="subject">
				<a href="<?php the_permalink() ?>" rel="bookmark" title="Permanent Link to <?php the_title(); ?>"><?php the_title(); ?></a>
			</span>
			
			<div class="entryInfo">
				<p><?php the_time('F j, Y \a\t\ g:i a'); ?></p>
				<?php comments_popup_link('<p>No comments.</p>', '<p>1 comment.</p>', '<p>% comments.</p>'); ?>
				<?php edit_post_link('Edit this entry.', '<p>', '</p>'); ?>
			</div>
			
			<div class="content">				
				<?php the_content("<b>Continue reading.</b>"); ?>
			</div>
			
			<?php link_pages('<div id="pageLinks">Pages:', '</div>', 'number', 'next page', 'previous page', '%'); ?>
			
		</div>
		
		<?php comments_template(); // Get wp-comments.php template ?>
		
		<?php endwhile; else: ?>
		<span class="subject">Four-oh-Four</span>
		<span class="content">
			<p><?php _e(''); ?>The page is out; leave a message at the beep.</p>
		</span>
		<?php endif; ?>
		
		<?php posts_nav_link(' &#8212; ', __('&laquo; Previous Page'), __('Next Page &raquo;')); ?>
		
	</div>
	
<?php get_footer(); ?>