<div id="sidebar">
<?php global $user_ID, $user_identity, $user_level ?>
<?php if ( $user_ID ) : ?>
<h3>Control panel</h3>
<div class="block">
<p>Identified as <strong><?php echo $user_identity ?></strong>.</p>
<ul>
<li><a href="<?php bloginfo('home') ?>/wp-admin/">Dashboard</a></li>
<?php if ( $user_level >= 1 ) : ?>
<li><a href="<?php bloginfo('home') ?>/wp-admin/post.php">Write an article</a></li>
<?php endif // $user_level >= 1 ?>
<li><a href="<?php bloginfo('home') ?>/wp-admin/profile.php">Profile and personal options</a></li>
<li><a href="<?php bloginfo('home') ?>/wp-login.php?action=logout&amp;redirect_to=<?php echo urlencode($_SERVER['REQUEST_URI']) ?>">Exit</a></li>
</ul>
</div>
<?php elseif ( get_option('users_can_register') ) : ?>
<h3>Identification</h3>
<div class="block">
<form action="<?php bloginfo('home') ?>/wp-login.php" method="post">
<p>
<label for="log"><input type="text" name="log" id="log" value="<?php echo wp_specialchars(stripslashes($user_login), 1) ?>" size="22" /> User</label><br />
<label for="pwd"><input type="password" name="pwd" id="pwd" size="22" /> Password</label><br />
<input type="submit" name="submit" value="Send" class="button" />
<label for="rememberme"><input name="rememberme" id="rememberme" type="checkbox" checked value="forever" /> Remember me</label><br />
</p>
<input type="hidden" name="redirect_to" value="<?php echo $_SERVER['REQUEST_URI']; ?>"/>
</form>
<ul>
<li><a href="<?php bloginfo('home') ?>/wp-register.php">Register</a></li>
<li><a href="<?php bloginfo('home') ?>/wp-login.php?action=lostpassword">Recover password</a></li>
</ul>
</div>
<?php endif // get_option('users_can_register') ?>
<?php if ( function_exists('wp_theme_switcher') ) : ?>
<h3>Theme switcher</h3>
<div class="block">
<?php wp_theme_switcher() ?>
</div>
<?php endif // function_exists('wp_theme_switcher') ?>
<?php if ( !is_search() ) : ?>
<h3>Article search</h3>
<div class="block">
<?php include (TEMPLATEPATH.'/searchform.php') ?>
</div>
<?php endif // !is_search() ?>
<h3>Sections</h3>
<div class="block">
<ul>
<?php global $cache_pages; $cache_pages = false ?>
<?php wp_list_pages('sort_column=post_name&show_date=xxx&date_format=(n.j.Y)&title_li=') ?>
</ul>
</div>
<?php if ( !is_home() ) : ?>
<?php if ( $posts = get_posts('numberposts=10') ) : ?>
<h3>Last articles</h3>
<div class="block">
<ul>
<?php foreach ( $posts as $post ) : ?>
<li><a href="<?php the_permalink() ?>" title="<?php echo trim(str_replace("\n"," ",preg_replace('#<[^>]*?>#si','',get_the_excerpt()))) ?>"><?php if ( get_the_title() ){ the_title(); }else{ echo "Untitled"; } ?></a> (<?php the_time('n.j.Y') ?>)</li>
<?php endforeach // $posts as $post ?>
</ul>
</div>
<?php endif // $posts ?>
<?php endif // !is_home() ?>
<h3>Categories</h3>
<div class="block">
<ul>
<?php wp_list_cats('sort_column=name&optioncount=1&exclude=10&feed=RSS&hide_empty=0') ?>
</ul>
</div>
<h3>Monthly archives</h3>
<div class="block">
<ul>
<?php wp_get_archives('type=monthly&show_post_count=1') ?>
</ul>
</div>
<h3>Favourite sites</h3>
<div class="block">
<ul>
<?php get_links_list('name') ?>
</ul>
</div>
<h3>Subscribe to this site</h3>
<div class="block">
<ul>
<li><a href="<?php bloginfo('rss2_url') ?>" title="Subscribe to the articles of this site" rel="feed">[+] Articles (RSS)</a></li>
<li><a href="<?php bloginfo('comments_rss2_url') ?>" title="Subscribe to the comments of this site" rel="feed">[+] Comments (RSS)</a></li>
</ul>
<p>Stay current with <?php bloginfo('name') ?> on these personalized pages:</p>
<ul>
<li><a href="http://www.bloglines.com/sub/<?php bloginfo('rss2_url') ?>" title="Add this site to Bloglines" rel="syndication">[+] Bloglines</a></li>
<li><a href="http://www.feedster.com/myfeedster.php?action=addrss&amp;rssurl=<?php echo urlencode(get_bloginfo('rss2_url')) ?>&amp;confirm=no" title="Add this site to Feedster" rel="syndication">[+] Feedster</a></li>
<li><a href="http://www.google.com/reader/preview/*/feed/<?php bloginfo('rss2_url') ?>" title="Add this site to Google" rel="syndication">[+] Google Reader</a></li>
<li><a href="http://feeds.my.aol.com/add.jsp?url=<?php echo urlencode(get_bloginfo('rss2_url')) ?>" title="Add this site to My AOL" rel="syndication">[+] My AOL</a></li>
<li><a href="http://my.msn.com/addtomymsn.armx?id=rss&amp;ut=<?php echo urlencode(get_bloginfo('rss2_url')) ?>&amp;ru=http://my.msn.com" title="Add this site to My MSN" rel="syndication">[+] My MSN</a></li>
<li><a href="http://add.my.yahoo.com/rss?url=<?php echo urlencode(get_bloginfo('rss2_url')) ?>" title="Add this site to My Yahoo" rel="syndication">[+] My Yahoo</a></li>
<li><a href="http://www.newsgator.com/ngs/subscriber/subext.aspx?url=<?php echo urlencode(get_bloginfo('rss2_url')) ?>" title="Add this site to Newsgator" rel="syndication">[+] Newsgator</a></li>
<li><a href="http://client.pluck.com/pluckit/prompt.aspx?a=<?php echo urlencode(get_bloginfo('rss2_url')) ?>&amp;t=<?php echo urlencode(get_option('blogname')) ?>" title="Add this site to Pluckit" rel="syndication">[+] Pluckit</a></li>
<li><a href="http://www.rojo.com/add-subscription?resource=<?php echo urlencode(get_bloginfo('rss2_url')) ?>" title="Add this site to Rojo" rel="syndication">[+] Rojo</a></li>
</ul>
</div>
</div>
