<?php


/** support for widgets **/
/** http://automattic.com/code/widgets/themes/ **/

function tomk32_widget_links($args) {
	global $wp_db_version;
	extract($args);
	$style = get_option('tomk32_widget_links');
	if ($style != 'multiple') {
		echo $before_widget, $before_title, __('Links'), $after_title;
		$after_copy = $after_widget;
		$after_widget = $before_widget = "";
	}
	if ( $wp_db_version < 3582 ) {
		// This ONLY works with li/h2 sidebars.
		get_links_list();
	} else {
	  if ($style != 'multiple') {
	    echo '<ul>';
	    wp_list_bookmarks(array('title_before' => '<strong>', 
				    'title_after' => '</strong>'));
	    echo '</ul>';
	  } else
	    wp_list_bookmarks(array('category_before' => $before_widget, 
				    'category_after' => $after_widget, 
				    'title_before'=>$before_title, 
				    'title_after'=>$after_title));
	}
	if ($style != 'multiple')
		echo $after_copy;
}

function tomk32_widget_links_control() {
	if (isset($_POST['tomk32_widget_links']) && in_array($_POST['tomk32_widget_links'], array('single', 'multiple')))
		update_option('tomk32_widget_links', $_POST['tomk32_widget_links']);
	$style = get_option('tomk32_widget_links');
	if (empty($style)) $style = 'multiple';
?>
	<div>
		<label><?php _e('Display in a single box or multiple? Single is the better choice if you have many link-categories.'); ?><br />
			<select name="tomk32_widget_links">
				<option value="single"<?php echo ($style == 'single') ? 'selected="selected"' : ""; ?>><?php _e('Single'); ?></option>
				<option value="multiple"<?php echo ($style == 'multiple') ? 'selected="selected"' : ""; ?>><?php _e('Multiple'); ?></option>
			</select>
		</label>
	</div>
<?php
}
if (function_exists('wp_theme_switcher')) {
function widget_wp_theme_switcher($args) {
	extract($args);
	echo $before_widget;
	echo '<div class="title">', __('Themes'), '</div>';
	wp_theme_switcher();
	echo $after_widget;
}
}
function tomk32_widget_search($args) {
	extract($args);
?>
		<?php echo $before_widget; ?>
			<div class="title"><?php _e('Search'); ?></div>
			<form id="searchform" method="get" action="<?php bloginfo('home'); ?>">
			<div>
			<input type="text" name="s" id="s" size="15" /><br />
			<input type="submit" value="<?php _e('Search'); ?>" />
			</div>
			</form>
		<?php echo $after_widget; ?>
<?php
}
function tomk32_theme_widgets() {
	register_sidebar(array(
		'before_widget' => '
<div class="portlet" id="%1$s">',
		'after_widget' => '</div>',
		'before_title' => '
<div class="title">',
		'after_title' => '</div>',
	));

	register_sidebar_widget(__('Links') . ' (TomK32 theme)', 'tomk32_widget_links');
	register_widget_control(__('Links') . ' (TomK32 theme)', 'tomk32_widget_links_control');
	register_sidebar_widget(__('Search') . ' (TomK32 theme)', 'tomk32_widget_search');
	if (function_exists('wp_theme_switcher'))
		register_sidebar_widget('Theme switcher', 'widget_wp_theme_switcher');

}
add_action('widgets_init', tomk32_theme_widgets);



function tomk32_add_theme_page() {
	if ( $_GET['page'] == basename(__FILE__) ) {
		if ( isset($_REQUEST['createWeblinksPage']) ) {
			$postid = wp_insert_post(Array('post_type' => "page", 'post_status' => "publish",
				'post_title' => __('Weblinks'), 'post_type' => 'page',
				'page_template' => 'weblinks.php'));
			if ($postid > 1)
			update_option('tomk32_weblinks', $postid);
		}
		if ( isset($_REQUEST['selectWeblinksPage']) ) {
			update_option('tomk32_weblinks', intval($_REQUEST['selectWeblinksPage']));
			wp_update_post(Array('ID' => intval($_REQUEST['selectWeblinksPage']),
					'page_template' => 'weblinks.php'));
		}
		if (isset($_REQUEST['tomk32_theme_numfullentries']))
			update_option('tomk32_theme_numfullentries', intval($_REQUEST['tomk32_theme_numfullentries']));
		if (is_array($_REQUEST['tomk32_theme_widgets']))
			update_option('tomk32_theme_widgets', $_REQUEST['tomk32_theme_widgets']);
		if (isset($_REQUEST['tomk32_quicklinks']))
			update_option('tomk32_quicklinks', $_REQUEST['tomk32_quicklinks']);
		if (isset($_REQUEST['tomk32_ads']))
			update_option('tomk32_ads', $_REQUEST['tomk32_ads']);
		if (isset($_REQUEST['tomk32_jQTR']))
			update_option('tomk32_jQTR', $_REQUEST['tomk32_jQTR']);
		if (isset($_REQUEST['tomk32_jQTR_dir']))
			update_option('tomk32_jQTR_dir', $_REQUEST['tomk32_jQTR_dir']);
		if (isset($_REQUEST['tomk32_quicklinks']))
			update_option('tomk32_quicklinks', $_REQUEST['tomk32_quicklinks']);
		if (isset($_REQUEST['tomk32_horizontal_nav'])) {
			unset($_REQUEST['tomk32_horizontal_nav'][0]);
			update_option('tomk32_horizontal_nav', array_keys($_REQUEST['tomk32_horizontal_nav']));
		}
	}
	add_theme_page(__('Configure theme'), __('Configure theme'), 'edit_themes', basename(__FILE__), 'tomk32_theme_page');
}

add_action('admin_menu', 'tomk32_add_theme_page');


function tomk32_theme_page() {
	if ( $_REQUEST['saved'] ) echo '<div id="message" class="updated fade"><p><strong>', __('Modifications have been saved'), '</strong></p></div>';
?>
<div class='wrap'>
<h2><?php _e('General settings'); ?></h2>
<form action="<?php echo $_SERVER['REQUEST_URI']; ?>" method="post">
<fieldset>
<table class="optiontable">
<?php 
$sidebars_widgets = get_option('sidebars_widgets');
if (function_exists('widgets_init') && ! empty($sidebars_widgets)) : 
	$tomk32_theme_widgets = get_option('tomk32_theme_widgets');
?>
	<tr><th scope="row"><label for="tomk32_theme_widgets"><?php _e('Widgets to be fully shown. This works globally and not (yet) per sidebar. The collapsed widgets can be uncollapsed with a click.'); ?></label>
</th><td>
	<fieldset name="tomk32_theme_widgets" id="tomk32_theme_widgets">
<?php foreach ($sidebars_widgets as $sidebar => $s_widgets) : ?>
	<h3><?php echo $sidebar; ?></h3>
	<ul style="list-style: none;">
<?php
	foreach ($s_widgets as $widget) : 
	$checked = "";
	if (isset($tomk32_theme_widgets[$sidebar][$widget])) $checked = 'checked="checked"';
?>
	<li><label><input type="checkbox"<?php echo " $checked"; ?> name="tomk32_theme_widgets[<?php echo $sidebar, '][', $widget;?>]" value="1" /> <?php echo $widget; ?></label></li>
<?php endforeach; ?>
	</ul>
	<?php endforeach; ?>
</fieldset>
	</td></tr>
<?php endif; ?>
<?php $tomk32_theme_numfullentries = get_option('tomk32_theme_numfullentries');
if ($tomk32_theme_numfullentries < 1) $tomk32_theme_numfullentries = 5; ?>
	<tr><th scope="row"><label for="tomk32_theme_numfullentries"><?php _e('How many posts should be fully shown on the frontpage?'); ?></label>
</th><td>
<input name="tomk32_theme_numfullentries" type="text" id="tomk32_theme_numfullentries" value="<?php echo $tomk32_theme_numfullentries; ?>" size="3" /> <?php printf(__('posts of %s'), get_option('posts_per_page')); ?>
	</td></tr>
<?php if (!function_exists('widgets_init') && empty($registered_widgets)) : ?>
	<tr><th scope="row"><label for="createWeblinksPage"><?php _e('Create a page containing all Weblinks'); ?></label></th>
	<td><input type="submit" name="createWeblinksPage" value="Create page" />
	</td></tr>
	<tr><th scope="row"><label for="selectWeblinksPage"><?php _e('Select a page to contain all weblinks, this site will be link to from the sidebar. Its page template will be set to weblinks.php automatically but no content will be lost.'); ?></label>
</th><td >
	<select size="3" name="selectWeblinksPage">
<?php
$pages = get_pages(array('sort_column' => 'menu_order'));
$tomk32_weblinks = get_option('tomk32_weblinks');

foreach ($pages as $post)
	printf('		<option value="%d"%s>%s</option>
', $post->ID, ($post->ID == $tomk32_weblinks) ? ' selected="selected"' : '', $post->post_title);
?>
	</select>
</td></tr>
<?php endif; ?>

	<tr><th scope="row"><label for="tomk32_horizontal_nav"><?php _e('Pages to be excluded from the horizontal navigation-bar.'); ?></label>
	</th><td >
<?php
$pages = get_pages(array('sort_column' => 'menu_order'));
$tomk32_horizontal_nav = get_option('tomk32_horizontal_nav');
if (!is_array($tomk32_horizontal_nav))
	$tomk32_horizontal_nav = Array();
echo '<input type="hidden" name="tomk32_horizontal_nav[0]" value="false" />';
foreach ($pages as $page)
	printf('		<label><input type="checkbox" name="tomk32_horizontal_nav[%d]"%s /> %s</label><br />
', $page->ID, (in_array($page->ID, $tomk32_horizontal_nav)) ? ' checked="checked"' : '', $page->post_title);
?>
	</td></tr>


	<tr><th scope="row"><label for="tomk32_quicklinks">
<?php _e('The additional Quicklinks will be displayed in the top-right corner.
On line per line with HTML'); ?></label></th>
	<td><textarea name="tomk32_quicklinks" id="tomk32_quicklinks"><?php echo get_option('tomk32_quicklinks'); ?></textarea>
	</td></tr>
	<tr><th scope="row"><label for="tomk32_ads">
<?php _e('Fill up with the code for your ads in the header. Or leave blank to hide.'); ?></label></th>
	<td><textarea name="tomk32_ads" id="tomk32_ads"><?php echo get_option('tomk32_ads'); ?></textarea>
	</td></tr>
	<tr><th scope="row"><label for="tomk32_jQTR">
<?php _e('Replace text from header and post titles with images?'); ?></label></th>
	<td><input type="checkbox" name="tomk32_jQTR" id="tomk32_jQTR" value="true" <?php 
		if (get_option('tomk32_jQTR') == true) echo ' checked="checked"'; ?> />
	</td></tr>
	<tr><th scope="row"><label for="tomk32_jQTR_dir">
<?php _e('Which images should be used to replace?'); ?></label></th>
	<td><select name="tomk32_jQTR_dir" id="tomk32_jQTR_dir">
<?php
	$theme_dir = get_theme_root() ."/". get_option('stylesheet');
	$dir = opendir( $theme_dir .  "/jQTR/");
	if ($dir) {
		while ($font_dir = readdir($dir)) {
			if (substr($font_dir, 0, 1) == ".")
				continue;
			printf('<option value="%1$s"%2$s>%1$s</option>', $font_dir,
			(get_option('tomk32_jQTR_dir') == $font_dir) ? ' selected="selected"' : "");
		}
	}
?></select>
	</td></tr><tr><td colspan="2">
	<input type="submit" />
</table>
</fieldset>
</form>

</div>
<?php
}

/** some Javascript **/
function tomk32_theme_head() {
	global $registered_widgets;
	$sidebar_widgets = get_option('sidebars_widgets');
	$tomk32_theme_widgets = get_option('tomk32_theme_widgets');
	if ( !empty($sidebar_widgets) 
			&& is_array($sidebar_widgets) 
			&& function_exists('dynamic_sidebar')
			&& is_array($tomk32_theme_widgets) ) {

	echo '<script type="text/javascript" language="Javascript">
$(document).ready( function() {
';
	foreach ($tomk32_theme_widgets as $sidebar => $widgets) {
		foreach ($widgets as $widget => $tmp) {
			if (!empty($registered_widgets[$widget])) 
			echo "	$('#" , $registered_widgets[$widget]['id'], " .title').addClass('show');\n";
	}
	}
	echo '});
</script>
';
	}

if (get_option('tomk32_jQTR')) : 
	$font_dir = "jQTR/" . get_option('tomk32_jQTR_dir') . "/";
	if (empty($font_dir)) $font_dir = "jQTR/rockwell/"
?>
<script type="text/javascript" src="<?php bloginfo('stylesheet_directory'); ?>/jqtr.php?path=<?php echo $font_dir ?>&jQTR_refresh=1"></script>
<script type="text/javascript" src="<?php bloginfo('stylesheet_directory'); ?>/jquery.jqtr.js"></script>
<script type="text/javascript">
$(document).ready(function() {
	if (typeof chartree == "undefined")
		return;
	$(".post .title a").add("#header h1 a").each(function() {
		$(this).text($(this).text().toUpperCase());
	});
	$(".post .title").not('.post .title a').each(function() {
		$(this).text($(this).text().toUpperCase());
	});
	$(".post .title a").add("#header h1 a").jQTR("png", "<?php bloginfo('stylesheet_directory'); echo '/' . $font_dir; ?>", chartree);
	$(".post .title").not('.post .title a').jQTR("png", "<?php bloginfo('stylesheet_directory'); echo '/' . $font_dir; ?>", chartree);
});
</script>
<?php 
endif;
?>
<script type="text/javascript">
	postsShowFully = <?php echo intval(get_option('tomk32_theme_numfullentries')); ?>;
</script>

<?php
}

add_action('wp_head', 'tomk32_theme_head');

?>