<?php
/**
 *	Name: Basic reads in the spanish blogoshpere
 *	Author: Diego F Gonzalez <dfgonzalez@gmail.com>
 *	URL: http://e.leven.com.ar/11feeds/
 */
 
// Start counting time for loading...
	$starttime = explode(' ', microtime());
	$starttime = $starttime[1] + $starttime[0];

//	I get the classes
	require('simplepie.inc.php');
	
//	And create the function to print all the feeds I want to
	function printFeed($title, $feedUrl, $desc=null)
	{
	//	I start the parsing engine
		$feed = new SimplePie();
		$feed->feed_url($feedUrl);
		$feed->init();
		if (!headers_sent() && $feed->get_encoding()) {
			header('Content-type: text/html; charset=' . $feed->get_encoding());
		}
		
		if($desc)
		{
			echo '<div class="content">';
			echo '<h2 class="title">';
			echo '<a class="alignright" href="' . $feedUrl . '"><img src="images/feed.png" alt="RSS" /></a>';
			echo $title . '</h2>';
			echo '<dl>';
			for($i=0; $i < $feed->get_item_quantity() && $i<15; $i++)
			{
				echo '<dt>';
				echo '<span class="action" id="' . removeHTTP($feed->get_item_permalink($i)) . $i . 'spanShow" onclick="Effect.BlindDown(\'' . removeHTTP($feed->get_item_permalink($i)) . $i . '\'); show(\'' . removeHTTP($feed->get_item_permalink($i)) . $i . 'spanHide\'); hide(this);"><img src="images/zoom_in.png" alt="show" /></span>';
				echo '<span style="display:none;" class="action" id="' . removeHTTP($feed->get_item_permalink($i)) . $i . 'spanHide" onclick="Effect.BlindUp(\'' . removeHTTP($feed->get_item_permalink($i)) . $i . '\'); show(\'' . removeHTTP($feed->get_item_permalink($i)) . $i . 'spanShow\'); hide(this);"><img src="images/zoom_out.png" alt="hide" /></span>';
				echo '<a href="' . $feed->get_item_permalink($i) . '">' . removeCdata($feed->get_item_title($i)) . '</a></dt>';
				echo '<dd id="' . removeHTTP($feed->get_item_permalink($i)) . $i . '" style="display:none">' . removeCdata($feed->get_item_description($i)) . '</dd>';
			}
			echo '</dl>';
			echo '</div>';
		}
		else
		{
			echo '<div class="content">';
			echo '<h2 class="title">';
			echo '<a class="alignright" href="' . $feedUrl . '"><img src="images/feed.png" alt="RSS" /></a>';
			echo $title . '</h2>';
			echo '<dl>';
			for($i=0; $i < $feed->get_item_quantity() && $i<15; $i++)
			{
			//	print_r($feed['items'][$i]);
				echo '<dt>';
				echo '<a href="' . $feed->get_item_permalink($i) . '">' . removeCdata($feed->get_item_title($i)) . '</a></dt>';
			}
			echo '</dl>';
			echo '</div>';
		}
	}
	
	function removeCdata($str)
	{
		$str = str_replace('<![CDATA[','',$str);
		$str = str_replace(']]>','',$str);
		$str = strip_tags($str, '');
		return $str;
	}
	
	function removeHTTP($str)
	{
		$str = str_replace('http://','',$str);
		$str = str_replace('.','',$str);
		return $str;
	}
?>