<?php
/*
Template Name: Archives
*/
?>
		
<?php get_header(); ?>
<div id="content">
<?php if (have_posts()) : ?>
	<?php $post = $posts[0]; // Hack. Set $post so that the_date() works. ?>
	<?php /* If this is a category archive */ if (is_category()) { ?>				
	<h2><a href="/">Archive for the '<?php echo single_cat_title(); ?>' Category</a></h2>
		
 	<?php /* If this is a daily archive */ } elseif (is_day()) { ?>
	<h2><a href="/">Archive for <?php the_time('F jS, Y'); ?></a></h2>
		
	<?php /* If this is a monthly archive */ } elseif (is_month()) { ?>
	<h2><a href="/">Archive for <?php the_time('F, Y'); ?></a></h2>

	<?php /* If this is a yearly archive */ } elseif (is_year()) { ?>
	<h2><a href="/">Archive for <?php the_time('Y'); ?></a></h2>
		
	<?php /* If this is a search */ } elseif (is_search()) { ?>
	<h2><a href="/">Search Results</a></h2>
		
	<?php /* If this is an author archive */ } elseif (is_author()) { ?>
	<h2><a href="/">Author Archive</a></h2>

	<?php /* If this is a paged archive */ } elseif (isset($_GET['paged']) && !empty($_GET['paged'])) { ?>
	<h2><a href="/">Blog Archives</a></h2>

<?php } ?>
<?php while (have_posts()) : the_post(); ?>

		<!-- POST START -->
		<div class="post">
			<h2><a href="<?php the_permalink() ?>"><?php the_title(); ?></a></h2>
			<?php the_excerpt() ?>
		</div>
		<!-- POST END -->
	<?php endwhile; ?>
	<div class="prevnextnav">
	<span class="floatleft"><?php next_posts_link('&laquo; Previous Entries') ?></span>
	<span class="floatright"><?php previous_posts_link('Next Entries &raquo;') ?></span>
	</div>
	<?php else : ?>
	<div class="post">
		<h2><a href="/">Not Found</a></h2>
		<p>Sorry, but yhou are looking for something that isn't here.</p>
	</div>
	<?php endif; ?>
</div><!-- #content -->
<?php get_sidebar(); ?>
<?php get_footer(); ?>