<?php 

// localisation won't work without
load_theme_textdomain('dkret');

// WIDGETS
if ( function_exists( 'register_sidebars' ) ) {
	register_sidebar(array('name'=>'Sidebar: Top'));
	register_sidebar(array('name'=>'Sidebar: Bottom'));

  if( bm_getProperty( 'Doublecolon' ) != 1 ) {
  	register_sidebar(array('name'=>'Sidebar: Colon1'));
  	register_sidebar(array('name'=>'Sidebar: Colon2'));
  }

  register_sidebar(array('name'=>'Footer: Colon1'));
  register_sidebar(array('name'=>'Footer: Colon2'));
  register_sidebar(array('name'=>'Footer: Colon3'));

  // now have a look for all available additional widgets and activate them
  $widgets_dir = @ dir(ABSPATH . '/wp-content/themes/' . get_template() . '/widgets');
  if ($widgets_dir)
  {
		while(($widgetFile = $widgets_dir->read()) !== false)
		{
			if (!preg_match('|^\.+$|', $widgetFile) && preg_match('|\.php$|', $widgetFile))
				include(ABSPATH . '/wp-content/themes/' . get_template() . '/widgets/' . $widgetFile);
		}
  }

  // some Widgets should be unregistered
  function unregister_problem_widgets() {
    unregister_sidebar_widget('Links');
    unregister_sidebar_widget('Meta');
    unregister_sidebar_widget('Search');
    unregister_sidebar_widget('Archiv');
    unregister_sidebar_widget('Calendar');
    unregister_sidebar_widget('Recent Posts');
  }

  add_action('widgets_init','unregister_problem_widgets');
}

function dkret_add_theme_page() {

	if ( $_GET['page'] == basename(__FILE__) ) {
	
	    // save settings
		if ( 'save' == $_REQUEST['action'] ) {

			update_option( 'dkret_name', $_REQUEST[ 'r_name' ] );
			update_option( 'dkret_email', $_REQUEST[ 'r_email' ] );
			update_option( 'dkret_about', $_REQUEST[ 'r_about' ] );
			update_option( 'dkret_headerImage', $_REQUEST[ 'r_headerImage' ] );
			update_option( 'dkret_headerImageURL', $_REQUEST[ 'r_headerImageURL' ] );

			if( isset( $_REQUEST[ 'r_head_subnavi' ] ) ) { update_option( 'dkret_head_subnavi', 1 ); } else { delete_option( 'dkret_head_subnavi' ); }
			if( isset( $_REQUEST[ 'r_subnavi' ] ) ) { update_option( 'dkret_subnavi', 1 ); } else { delete_option( 'dkret_subnavi' ); }
			if( isset( $_REQUEST[ 'r_doublecolon' ] ) ) { update_option( 'dkret_doublecolon', 1 ); } else { delete_option( 'dkret_doublecolon' ); }
			if( isset( $_REQUEST[ 'r_randompic' ] ) ) { update_option( 'dkret_randompic', 1 ); } else { delete_option( 'dkret_randompic' ); }
			if( isset( $_REQUEST[ 'r_events' ] ) ) { update_option( 'dkret_events', 1 ); } else { delete_option( 'dkret_events' ); }
			//if( isset( $_REQUEST[ 'r_markExternalLinks' ] ) ) { update_option( 'dkret_markExternalLinks', 1 ); } else { delete_option( 'dkret_markExternalLinks' ); }
			if( isset( $_REQUEST[ 'r_calendar' ] ) ) { update_option( 'dkret_calendar', 1 ); } else { delete_option( 'dkret_calendar' ); }
			if( isset( $_REQUEST[ 'r_meta' ] ) ) { update_option( 'dkret_meta', 1 ); } else { delete_option( 'dkret_meta' ); }
			if( isset( $_REQUEST[ 'r_posts' ] ) ) { update_option( 'dkret_posts', 1 ); } else { delete_option( 'dkret_posts' ); }
			if( isset( $_REQUEST[ 'r_months' ] ) ) { update_option( 'dkret_months', 1 ); } else { delete_option( 'dkret_months' ); }
			if( isset( $_REQUEST[ 'r_linkcat' ] ) ) { update_option( 'dkret_linkcat', 1 ); } else { delete_option( 'dkret_linkcat' ); }
			if( isset( $_REQUEST[ 'r_heading' ] ) ) { update_option( 'dkret_heading', 1 ); } else { delete_option( 'dkret_heading' ); }

			// goto theme edit page
			header("Location: themes.php?page=functions.php&saved=true");
			die;

  		// reset settings
		} else if( 'reset' == $_REQUEST['action'] ) {

			delete_option( 'dkret_name' );
			delete_option( 'dkret_email' );
			delete_option( 'dkret_about' );
			delete_option( 'dkret_headerImage' );
			delete_option( 'dkret_headerImageURL' );
			//delete_option( 'dkret_markExternalLinks' );
			delete_option( 'dkret_head_subnavi' );
			delete_option( 'dkret_subnavi' );
			delete_option( 'dkret_doublecolon' );
			delete_option( 'dkret_calendar' );
			delete_option( 'dkret_meta' );
			delete_option( 'dkret_posts' );
			delete_option( 'dkret_months' );
			delete_option( 'dkret_linkcat' );
			delete_option( 'dkret_heading' );
			delete_option( 'dkret_randompic' );
			delete_option( 'dkret_events' );

			// goto theme edit page
			header("Location: themes.php?page=functions.php&reset=true");
			die;

		}
	}

    add_theme_page(__('dkret Theme options','dkret'), __('dKret Options','dkret'), 'edit_themes', basename(__FILE__), 'dkret_theme_page');

}

function dkret_theme_page() {

	// --------------------------
	// dkret theme page content
	// --------------------------

	if ( $_REQUEST['saved'] ) echo '<div id="message" class="updated fade"><p><strong>'.__('Settings saved.','dkret').'</strong></p></div>';
	if ( $_REQUEST['reset'] ) echo '<div id="message" class="updated fade"><p><strong>'.__('Settings reset.','dkret').'</strong></p></div>';
	
?>

<?php if (WPLANG=='') : ?>
	<div class="error">
		<h1>YOU HAVEN'T CONFIGURED YOUR BLOG LANGUAGE IN wp-config.php YET! LOCALIZATION WON'T WORK WITHOUT SETTING YOUR LOCALE!</h1>
	</div>
<?php endif; ?>

<div class="wrap">
<h2>dKret</h2>

<p>
  <?php _e('Developed by','dkret'); ?> J.Kretzschmar.<br />
  <?php _e('Theme-Options inspired by <a href="http://www.binarymoon.co.uk/projects/regulus/">Regulus</a>. Visit <a href="http://diekretzschmars.de/dkret-theme/">diekretzschmars.de</a> for updates.','dkret'); ?>
</p>

<form method="post">

<!-- blog layout options -->
<script>

function updateHeaderImage( newpic ) {

	newimage = "<?php bloginfo('template_url') ?>/images/bg_" + newpic.value + ".jpg";

	document.getElementById( 'placeholder' ).src = newimage;
	return true;

}

function updateHeaderImageSelect( form ) {

	text = form.r_headerImageURL.value;
	
    if ( text == "" ) {
    
        newpic = form.r_headerImage.value;
    
		newimage = "<?php bloginfo('template_url') ?>/images/bg_" + newpic + ".jpg";

 		form.r_headerImage.disabled = 0;
		
	} else {
	
		newimage = form.r_headerImageURL.value;
		
		form.r_headerImage.disabled = 1;
		
	}
	
	document.getElementById( 'placeholder' ).src = newimage;
}

function defaultImage() {

	newimage = "<?php bloginfo('template_url') ?>/images/bg_disabled.jpg";

	document.getElementById( 'placeholder' ).src = newimage;

}

</script>

<fieldset class="options">
<legend><?php _e('Header Settings','dkret'); ?></legend>

<p><?php _e('To use your own header image enter the <strong>complete</strong> url into the Header Image URL box below - eg "http://www.yoursite.com/yourfile.jpg". To fill the header area completely you should make the image <strong>900</strong> pixels wide by <strong>140</strong> pixels high. Any smaller and the image will tile. To use one of the supplied images simply leave this box blank and select the image from the drop down.','dkret'); ?></p>

<table width="100%" cellspacing="2" cellpadding="5" class="editform">

<?php


	dkret_th(__('Header Image URL','dkret'));
		dkret_input( "r_headerImageURL", "text", "", get_settings( 'dkret_headerImageURL' ), "", "updateHeaderImageSelect( this.form )" );
	dkret_cth();

	$value = get_settings( 'dkret_headerImage' );
	
	if ( get_settings( 'dkret_headerImageURL' ) != "" ) {
	
	    $disabled = true;

	}
	
	dkret_th(__('Header Image','dkret'));

		if ( $disabled == true ) {
			echo "<select name=\"r_headerImage\" style=\"width:60%;\" onchange=\"updateHeaderImage( this )\" disabled=\"true\">";
		} else {
            echo "<select name=\"r_headerImage\" style=\"width:60%;\" onchange=\"updateHeaderImage( this )\">";
		}
	    
		dkret_input( "r_headerImage", "option", "dKret", "1", $value );
		dkret_input( "r_headerImage", "option", "Sky", "2", $value );
		dkret_input( "r_headerImage", "option", "Loens-Realschule", "3", $value );
		// dkret_input( "r_headerImage", "option", "Random", "random", $value );
		echo "</select>";
		
		echo "<img id=\"placeholder\" onError=\"defaultImage();\" src=\"";
		bloginfo('template_url');
		
		if ( $disabled == true ) {
			echo "/images/bg_disabled.jpg\" width=\"60%\" />";
		} else {
			echo "/images/bg_$value.jpg\" width=\"60%\" />";
		}

		
	dkret_cth();
	
	dkret_th(__('Header Settings','dkret'));
			dkret_input( "r_heading", "checkbox", __('Hide titel and subtitel?','dkret'), "1", get_settings( 'dkret_heading' ) );
			dkret_input( "r_head_subnavi", "checkbox", __('Hide subnavigation?','dkret'), "1", get_settings( 'dkret_head_subnavi' ) );
	dkret_cth();
	
?>

</table>
</fieldset>

<fieldset class="options">
<legend><?php _e('Blog Settings','dkret'); ?></legend>

<table width="100%" cellspacing="2" cellpadding="5" class="editform">

<?php 
  
	$display_dkret_sidebar = false;

  dkret_th(__('General Settings','dkret'));
    	dkret_input( "r_meta", "checkbox", __('Hide meta?','dkret'), "1", get_settings( 'dkret_meta' ) );
			dkret_input( "r_months", "checkbox", __('Show only 10 month of the archiv?','dkret'), "1", get_settings( 'dkret_months' ) );
			dkret_input( "r_posts", "checkbox", __('Show recent posts?','dkret'), "1", get_settings( 'dkret_posts' ) );
			//dkret_input( "r_markExternalLinks", "checkbox", __('Mark external links?','dkret'), "1", get_settings( 'dkret_markExternalLinks' ) );


	dkret_th(__('Sidebar Settings','dkret'));
	
		// if plugin installed
		if ( !function_exists('is_dynamic_sidebar') ) {
		
			$display_dkret_sidebar = true;
			
		} else {
		
		    //plugin installed - is it used?
		    if ( is_dynamic_sidebar() == false ) { $display_dkret_sidebar = true; }

		}

		// display dkret sidebar settings

      dkret_input( "r_subnavi", "checkbox", __('Hide Subnavigation?','dkret'), "1", get_settings( 'dkret_subnavi' ) );
      dkret_input( "r_doublecolon", "checkbox", __('Hide Doublecolons?','dkret'), "1", get_settings( 'dkret_doublecolon' ) );
			dkret_input( "r_linkcat", "checkbox", __('Hide link categories in blogroll?','dkret'), "1", get_settings( 'dkret_linkcat' ) );
			dkret_input( "r_calendar", "checkbox", __('Show calendar?','dkret'), "1", get_settings( 'dkret_calendar' ) );

    if (function_exists('ec3_get_events')) {
			 dkret_input( "r_events", "checkbox", __('Show recent events?','dkret'), "1", get_settings( 'dkret_events' ) );
    }

		if (function_exists('myrandompic')) {
			 dkret_input( "r_randompic", "checkbox", __('Show random picture?','dkret'), "1", get_settings( 'dkret_randompic' ) );
    }
      
	dkret_cth();

?>

</table>

</fieldset>


<!-- personal options -->
<fieldset class="options">
<legend><?php _e('Personal Information','dkret'); ?></legend>

<p><?php _e('The about information will appear at the top of the right hand column (optional).','dkret'); ?></p>

<table width="100%" cellspacing="2" cellpadding="5" class="editform">

<?php

	dkret_th(__('About You','dkret'));
		dkret_input( "r_about", "textarea", "", get_settings( 'dkret_about' ) );
	dkret_cth();

?>

</table>

</fieldset>

<?php

	dkret_input( "save", "submit", "", __('Save Settings','dkret') );
	
?>

<input type="hidden" name="action" value="save" />

</form>



<form method="post">

<fieldset class="options">
<legend><?php _e('Reset','dkret'); ?></legend>

<p><?php _e('If for some reason you want to uninstall dKret then press the reset button to clean things up in the database.','dkret'); ?></p>
<?php

	dkret_input( "reset", "submit", "", __('Reset Settings','dkret') );
	
?>

</div>

<input type="hidden" name="action" value="reset" />

</form>

<?php
}

add_action('admin_menu', 'dkret_add_theme_page');


// helper functions
// ----------------

function dkret_input( $var, $type, $description = "", $value = "", $selected="", $onchange="" ) {

	// ------------------------
	// add a form input control
	// ------------------------
	
 	echo "\n";
 	
	switch( $type ){
	
	    case "text":

	 		echo "<input name=\"$var\" id=\"$var\" type=\"$type\" style=\"width: 60%\" class=\"code\" value=\"$value\" onchange=\"$onchange\"/>";
			
			break;
			
		case "submit":
		
	 		echo "<p class=\"submit\"><input name=\"$var\" type=\"$type\" value=\"$value\" /></p>";

			break;

		case "option":
		
			if( $selected == $value ) { $extra = "selected=\"true\""; }

			echo "<option value=\"$value\" $extra >$description</option>";
		
		    break;
  		case "radio":
  		
			if( $selected == $value ) { $extra = "checked=\"true\""; }
  		
  			echo "<label><input name=\"$var\" id=\"$var\" type=\"$type\" value=\"$value\" $extra /> $description</label><br/>";
  			
  			break;
  			
		case "checkbox":
		
			if( $selected == $value ) { $extra = "checked=\"true\""; }

  			echo "<label><input name=\"$var\" id=\"$var\" type=\"$type\" value=\"$value\" $extra /> $description</label><br/>";

  			break;

		case "textarea":
		
		    echo "<textarea name=\"$var\" id=\"$var\" style=\"width: 60%; height: 10em;\" class=\"code\">$value</textarea>";
		
		    break;
	}

}

function dkret_th( $title ) {

	// ------------------
	// add a table header
	// ------------------

   	echo "<tr valign=\"top\">";
	echo "<th width=\"33%\" scope=\"row\">$title :</th>";
	echo "<td>";

}

function dkret_cth() {

	echo "</td>";
	echo "</tr>";
	
}


function bm_getProperty( $property ) {

	$value = get_settings( "dkret_" . $property );
	
	if( $value == "1" ) {
        return 1;
	} else {
		return 0;
	}
	

}

// -------------------------------------
// format html for display in a web page
// -------------------------------------
function bm_tidy_html( $data ) {

	//remove dodgy characters
	$data = htmlspecialchars( $data );
	//remove carriage returns
	$data = str_replace( "\r", "", $data );
	//swap newlines for line breaks
	$data = str_replace( "\n", "<br />", $data );
	//replace <br>
	$data = str_replace( "<br>", "<br />", $data );
	//add paragraph tags
	$data = "<p>" . str_replace( "<br /><br />", "</p>\n<p>", $data ) . '</p>';
	//remove newline at the end of paragraphs
	$data = str_replace( "<br /></p>", "</p>", $data);
	//remove empty paragraphs
	$data = str_replace( "<p></p>", "", $data);
	$data = str_replace( "<p><br></p>", "", $data );

	$data = stripslashes( $data );

	return $data;

}

function mg_filter_the_date($the_date)
{
  global $ec3;
  $event_cat = get_option('ec3_event_category');

  if (!empty($ec3) && (in_category($event_cat) || is_category($event_cat)))
  {
    $the_date = '';  
  }
  return $the_date;
}

add_filter('the_date', 'mg_filter_the_date');
add_filter('the_time', 'mg_filter_the_date'); 

?>
