<?php get_header(); ?>

<?php if (have_posts()) : ?>

	<?php while (have_posts()) : the_post(); ?>

		<div class="post" id="post-<?php the_ID(); ?>">
			<h2><a href="<?php the_permalink() ?>" rel="bookmark" title="Permalink: <?php the_title(); ?>"><?php the_title(); ?></a></h2>
			<p class="date"><?php the_time('F j, Y') ?></p>
			
			<?php
				if ( is_home() || is_single() || is_page() ) {
					the_content(__('(more...)'));
				}
				else {
					the_excerpt();
				}
			?>
			<?php if(is_single() || is_page()) { link_pages('<p><strong>'.__('Pages:').'</strong> ', '</p>', 'number'); } ?>
			<?php if ( ! is_page() ) { ?>
	
				<p class="details_small">
					<?php _e("Filed under:"); ?> <?php the_category(', ') ?> | 
					<?php edit_post_link(__('Edit This'), '',' |'); ?> 
					<?php comments_popup_link(__('Comments (0)'), __('Comments (1)'), __('Comments (%)')); ?>
				</p>
			
			<?php } ?>
		</div>
		
		<?php if ( is_single() ) comments_template(); ?>

	<?php endwhile; ?>
	<?php if ( ! is_single() ) { ?>
		<div class="navigation">
			<?php posts_nav_link(' &#8212; ', '<span class="alignleft">'. __('&laquo; Previous Page') .'</span>', '<span class="alignright">'. __('Next Page &raquo;').'</span>'); ?>
		</div>
	<?php } 
	else { ?>
		<div class="navigation">
			<span class="alignleft"><?php previous_post_link('&laquo; %link') ?></span>
			<span class="alignright"><?php next_post_link('%link &raquo;') ?></span>
		</div>
	<?php } ?>

<?php else : ?>

	<h2 class="center">Not found</h2>
	<p class="center"><?php _e('Sorry, no posts matched your criteria.'); ?></p>
	<?php include (TEMPLATEPATH . '/searchform.php'); ?>

<?php endif; ?>

<?php get_footer(); ?>
