<?php get_header(); ?>

	<div id="primary" class="single-post">
		<div class="inside">
			<?php if (have_posts()) : while (have_posts()) : the_post(); ?>
			<div class="primary">
				<h1><?php the_title(); ?></h1>
				<?php the_content('<p class="serif">Lese den ganzen Artikel...</p>'); ?>
			</div>
			<hr class="hide" />
			<div class="secondary">
				<h1>Infos zum Artikel:</h1>
				<div class="featured">
					<p>Du liest gerade: <?php the_title(); ?><br />Weblog: <?php bloginfo('name'); ?></p>
					<dl>
						<dt>Erschienen:</dt>
						<dd><?php the_time('l, j.m.Y') ?> / <?php the_time('H:i') ?>Uhr</dd>
					</dl>
					<dl>
						<dt>Kategorie:</dt>
						<dd><?php the_category(', ') ?></dd>
					</dl>
					<?php edit_post_link('Editiere diesen Artikel.', '<dl><dt>Ändern:</dt><dd> ', '</dd></dl>'); ?>
				</div>
			</div>
			<div class="clear"></div>
		</div>
	</div>
	<!-- [END] #primary -->
	
	<hr class="hide" />
	<div id="secondary">
		<div class="inside">
			
			<?php if ('open' == $post-> comment_status) {
				// Comments are open ?>
				<div class="comment-head">
					<h2><?php comments_number('No comments','1 Comment','% Comments'); ?></h2>
					<span class="details"><a href="#comment-form">Spring zum Formular</a> | <?php comments_rss_link('kommentar rss'); ?> <a href="#what-is-comment-rss" class="help">[?]</a> <?php if ('open' == $post->ping_status): ?>| <a href="<?php trackback_url(true); ?>">trackback uri</a> <a href="#what-is-trackback" class="help">[?]</a><?php endif; ?></span>
				</div>
			<?php } elseif ('open' != $post-> comment_status) {
				// Neither Comments, nor Pings are open ?>
				<div class="comment-head">
					<h2>Kommentieren ausgeschlossen.</h2>
					<span class="details">Keine Chance zum spammen.</span>
				</div>	
			<?php } ?>
			
			<?php comments_template(); ?>
			
			<?php endwhile; else: ?>
			<p>Sorry, hast heute leider kein Glück mit dem Suchen.</p>
			<?php endif; ?>
		</div>
	</div>
<?php get_sidebar(); ?>
<?php get_footer(); ?>
