<?php
/*
Plugin Name: Weather widget
Description: Adds a sidebar widget to display weather from weather.com.
Author: Nikynik
Version: 1.0
Author URI: http://www.nikynik.com
*/
   // Check for the required plugin functions. This will prevent fatal
	// errors occurring when you deactivate the dynamic-sidebar plugin.
	if ( !function_exists('register_sidebar_widget') )
		return;

	// This is the function that outputs the Zen Photo images
	function widget_citrus_Weather($args) {
		
		// $args is an array of strings that help widgets to conform to
		// the active theme: before_widget, before_title, after_widget,
		// and after_title are the array keys. Default tags: li and h2.
		extract($args);

		// Each widget can store its own options. We keep strings here.
		$options = get_option('widget_citrus_Weather');
		$title = $options['title'];

		// These lines generate our output.
		echo $before_widget . $before_title . $title . $after_title;
		$url_parts = parse_url(get_bloginfo('home'));

		if ( function_exists('WeatherIcon') ) {
		WeatherIcon('station=LIBG&before=<li>&after=</li>');
			  } else {  
                        echo '<ul><li>Weather plugin not enabled or missing</li><li>Go to 
				<a href="http://www.viper007bond.com/wordpress-plugins/weathericon/">Author plugin</a> to download</li></UL>';
                }

		echo $after_widget;
	}

	// This is the function that outputs the form to let the users edit
	// the widget's title. It's an optional feature that users cry for.
	function widget_citrus_Weather_control() {

		// Get our options and see if we're handling a form submission.
		$options = get_option('widget_citrus_Weather');
		if ( !is_array($options) )
			$options = array('title'=>'');

		if ( $_POST['Weather-submit'] ) {

			// Remember to sanitize and format use input appropriately.
			$options['title'] = strip_tags(stripslashes($_POST['Weather-title']));
			update_option('widget_citrus_Weather', $options);
		}

		// Be sure you format your options to be valid HTML attributes.
		$title = htmlspecialchars($options['title'], ENT_QUOTES);
		
		// Here is our little form segment. Notice that we don't need a
		// complete form. This will be embedded into the existing form.
		echo '<p style="text-align:right;"><label for="Weather-title">Title: <input style="width: 200px;" id="Weather-title" name="Weather-title" type="text" value="'.$title.'" /></label></p>';
		echo '<input type="hidden" id="Weather-submit" name="Weather-submit" value="1" />';
	}
	
	// This registers our widget so it appears with the other available
	// widgets and can be dragged and dropped into any active sidebars.
	register_sidebar_widget('Citrus Weather', 'widget_citrus_Weather');

	// This registers our optional widget control form. Because of this
	// our widget will have a button that reveals a 300x100 pixel form.
	register_widget_control('Citrus Weather', 'widget_citrus_Weather_control', 300, 100);


?>