<?php
// =====================================================
//  UTF AND COMMENTS
// =====================================================

class citrus {
        function utf8_encode($string) {
                $matches = array();
                preg_match('/AppleWebKit\/([0-9]+\.[0-9])/', $_SERVER['HTTP_USER_AGENT'], $matches);
                if(count($matches) > 0 && (float) $matches[1] <= 417.9){
                        return $string;
                } else {
                        return utf8_encode($string);
                }
        }

        function utf8_decode($string) {
                $matches = array();
                preg_match('/AppleWebKit\/([0-9]+\.[0-9])/', $_SERVER['HTTP_USER_AGENT'], $matches);
                if(count($matches) > 0 && (float) $matches[1] <= 417.9){
                        return utf8_decode($string);
                } else {
                        return $string;
                }
        }

        function handle_add_comment($id, $approved) {
                // Override the HTTP/1.0 500 header we sent out prev.
                header("HTTP/1.0 200 OK");

                if( isset($_POST['ajax'])) {
                        // We need to fetch the comment again...
                        $comment = get_comment($id);

                        // Since we are going to "kill" this process to avoid the Location-header, we have to emul what the rest of wp_new_comment
                        if ( 'spam' !== $approved ) { // If it's spam save it silently for later crunching
                                if ( '0' == $approved ) {
                                        wp_notify_moderator($id);
                                }

                                $post = &get_post($comment->comment_post_ID); // Don't notify if it's your own comment

                                if ( get_settings('comments_notify') && $approved && $post->post_author != $comment->user_ID ) {
                                        wp_notify_postauthor($id, $comment->comment_type);
                                }
                        }

                        if( empty($comment->comment_author_url) || trim($comment->comment_author_url) == 'http://' ) {
                                $link = $comment->comment_author;
                        } else {
                                //echo '<pre>' . print_r($comment, true) . '</pre>';
                                $link = '<a href="' . $comment->comment_author_url . '" rel="external nofollow">' . $comment->comment_author . '</a>';
                        }

                        $post  = '<div class="commentcontent">' . "\n";
                        $post .= '    <p>' . apply_filters('comment_text', apply_filters('get_comment_text', $comment->comment_content)) . '</p>' . "\n";
                        $post .= '<p class="commentinfo"><cite>' . __('Comment') . ' '. __('by') . ' ' . $link . ' &#8212; ' . date(get_settings('date_format'), time()) . ' @ <a href="#comment-' . $comment_id . '">' . date(get_settings('time_format'), time()) . '</a></cite></p>' . "\n";
                        $post .= '</div></div>';

                        echo citrus::utf8_decode($post);
                        die;
                }
        }
}

add_action('comment_post', array('citrus', 'handle_add_comment'), 1, 2);

// =====================================================
// BEGIN WIDGETS SIDEBAR SUPPORT
// =====================================================

if ( function_exists('register_sidebar') )
   {
         register_sidebar(array(
                 'name' => 'Left Sidebar',
        'before_widget' => '<ul>',
        'after_widget' => '</ul>',
        'before_title' => '<h3>',
        'after_title' => '</h3>',
));

if ( function_exists('register_sidebar') )
   {
         register_sidebar(array(
                 'name' => 'Middle Sidebar',
        'before_widget' => '<ul>',
        'after_widget' => '</ul>',
        'before_title' => '<h3>',
        'after_title' => '</h3>',
));

if ( function_exists('register_sidebar') )
   {
         register_sidebar(array(
                 'name' => 'Right Sidebar',
        'before_widget' => '<ul>',
        'after_widget' => '</ul>',
        'before_title' => '<h3>',
        'after_title' => '</h3>',
));

        // now have a look for all available additional widgets and activate them
        $widgets_dir = @ dir(ABSPATH . '/wp-content/themes/' . get_template() . '/widgets');
        if ($widgets_dir)
        {
                while(($file = $widgets_dir->read()) !== false)
                {
                          if (!preg_match('|^\.+$|', $file) && preg_match('|\.php$|', $file))
                                        //$scheme_files[] = preg_replace('|\.php$|', '', $file);
                                        include(ABSPATH . '/wp-content/themes/' . get_template() . '/widgets/' . $file);
                }
        }
}
}
// =====================================================
// END WIDGETS SIDEBAR SUPPORT
// =====================================================
}
?>
<?php
add_action('admin_menu', 'citrus_add_theme_page');

function citrus_add_theme_page() {
        if ( '1' != get_settings('citrus_is_active') ) {
                // set default options if the theme hasn't been set up yet
               	
			    update_option('citrus_posts','1');
                update_option('citrus_asides_cat', '');
                update_option('citrus_num_asides', '10');

        }
        if ( 'save-citrusoptions' == $_REQUEST['action'] ) {
                // save options, and revert to defaults if left blank

                if ( isset($_REQUEST['asides_cat']) ) {
                        if ( '' == $_REQUEST['asides_cat'] )
                                delete_option('citrus_asides_cat');
                        else
                                update_option('citrus_asides_cat', $_REQUEST['asides_cat']);
                }
                if ( isset($_REQUEST['numasides']) ) {
                        if ( '' == $_REQUEST['numasides'] )
                                update_option('citrus_numasides', '10');
                        else
                                update_option('citrus_numasides', $_REQUEST['numasides']);
                }
				if ( isset($_REQUEST['posts']) ) {
			if ( '' == $_REQUEST['posts'] )
				update_option('citrus_posts', '1');
			else
				update_option('citrus_posts', $_REQUEST['posts']);
		}
            if ( isset($_REQUEST['num_frontpage_posts']) ) {
             if ( '' == $_REQUEST['num_frontpage_posts'] )
                update_option('citrus_num_frontpage_posts', '1');
            else
               update_option('citrus_num_frontpage_posts', $_REQUEST['num_frontpage_posts']);
                }
		header("Location: themes.php?page=functions.php&saved=true");
                die;
        }
        update_option('citrus_version', 'Beta 0.6');

        add_theme_page("citrus Theme Options", "The Citrus Options", 'edit_themes', basename(__FILE__), 'citrus_theme_page');
}


function citrus_theme_page() {
if ( $_REQUEST['saved'] ) echo '<div id="message" class="updated fade"><p><strong>Options saved.</strong></p></div>';
?>

<div class="wrap">
<form method="POST">
<h2>CITRUS Options</h2>
<p>Version: <?php echo get_settings('citrus_version'); ?></p>
<?php update_option('citrus_is_active', '1'); ?>
<h3>Basic Options</h3><br />
<h2>Frontpage Posts</h2>
<p>
  <label for="posts">
Show other posts after the first post in the front page? </label>
<input type="radio" name="posts" value="1" <?php if(get_settings('citrus_posts') == 1) {echo 'checked';} ?> > Yes</input> <input type="radio" name="posts" value="0" <?php if(get_settings('citrus_posts') != 1) {echo 'checked';} ?> > No</input><br />
  <label for="num_frontpage_posts">Number of posts to display on the front page after the first post: </label>
<input type="text" name="num_frontpage_posts" size="5" value="<?php echo get_settings('citrus_num_frontpage_posts'); ?>" /></p>
<h2>Asides</h2>
<p>
  <label for="asides_cat">Asides Category:  </label>
<?php
                        global $wpdb;
                        $id = get_option('citrus_asides_cat');
                        if ($id != 0) {
                        $asides_title = $wpdb->get_var("SELECT cat_name from $wpdb->categories WHERE cat_ID = $id");
                        } else {
                                $asides_title='No Asides';
                                }
                        $asides_cats = $wpdb->get_results("SELECT * from $wpdb->categories");
                        ?>
                        <select name="asides_cat" id="asides_text" style="width: 300px;">
                        <option value="<?php echo get_settings('citrus_asides_cat'); ?>"><?php echo $asides_title; ?></option>
                        <option value="-----">----</option>
                        <option value="0">No Asides</option>
                        <?php
                        foreach ($asides_cats as $cat) {
                        echo '<option value="' . $cat->cat_ID . '">' . $cat->cat_name . '</option>';
            }
            ?>
                        </select>
                        <br />
<p><label for="numasides">Number of asides category to display in sidebar widget: </label>
<input type="text" size="3" name="numasides" value="<?php echo get_settings('citrus_numasides'); ?>" /></p>

<input type="hidden" name="action" value="save-citrusoptions" />

<p align="right"><input type="submit" name="Submit" value="Update Options &raquo;" /></p>
</form>
</div>


<?php } ?>