<?php
/*
Block Name: Blog Stats
Version: 1.0
Block URI: http://www.freshpursuits.com/canvas
Author: Yas
Description: A quick summary of the number of posts and comments on your blog.
Group: Wordpress
*/
   // Check for the required plugin functions. This will prevent fatal
        // errors occurring when you deactivate the dynamic-sidebar plugin.
        if ( !function_exists('register_sidebar_widget') )
                return;

        // This is the function that outputs the Zen Photo images
        function widget_citrus_blogstats($args) {

                // $args is an array of strings that help widgets to conform to
                // the active theme: before_widget, before_title, after_widget,
                // and after_title are the array keys. Default tags: li and h2.
                extract($args);

                // Each widget can store its own options. We keep strings here.
                $options = get_option('widget_citrus_blogstats');
                $title = $options['title'];

                // These lines generate our output.
                echo  $before_title . $title . $after_title;

$url_parts = parse_url(get_bloginfo('home'));
global $wpdb;
$numposts = $wpdb->get_var("SELECT COUNT(*) FROM $wpdb->posts WHERE post_status = 'publish'");
if (0 < $numposts) $numposts = number_format($numposts);

$numcomms = $wpdb->get_var("SELECT COUNT(*) FROM $wpdb->comments WHERE comment_approved = '1'");
if (0 < $numcomms) $numcomms = number_format($numcomms);

$numcats = $wpdb->get_var("SELECT COUNT(*) FROM $wpdb->categories");
if (0 < $numcats) $numcats = number_format($numcats);

                printf(__('<strong>There are currently </strong><li><strong>%1$s posts</strong></li><li> <strong>%2$s comments</strong></li><li><strong>%3$s categories</strong></li>','citrus'), $numposts, $numcomms, $numcats);
                ?>
                <?php if (function_exists(akismet_count)) { ?>
                <li><?php akismet_count(1); ?></li><?php } ?> <?php
                echo $after_widget;
        }

        // This is the function that outputs the form to let the users edit
        // the widget's title. It's an optional feature that users cry for.
        function widget_citrus_blogstats_control() {

                // Get our options and see if we're handling a form submission.
                $options = get_option('widget_citrus_blogstats');
                if ( !is_array($options) )
                        $options = array('title'=>'');

                if ( $_POST['blogstats-submit'] ) {

                        // Remember to sanitize and format use input appropriately.
                        $options['title'] = strip_tags(stripslashes($_POST['blogstats-title']));
                        update_option('widget_citrus_blogstats', $options);
                }

                // Be sure you format your options to be valid HTML attributes.
                $title = htmlspecialchars($options['title'], ENT_QUOTES);

                // Here is our little form segment. Notice that we don't need a
                // complete form. This will be embedded into the existing form.
                echo '<p style="text-align:right;"><label for="blogstats-title">Title: <input style="width: 200px;" id="blogstats-title" name="blogstats-title" type="text" value="'.$title.'" /></label></p>';
                echo '<input type="hidden" id="blogstats-submit" name="blogstats-submit" value="1" />';
        }

        // This registers our widget so it appears with the other available
        // widgets and can be dragged and dropped into any active sidebars.
        register_sidebar_widget('Citrus blogstats', 'widget_citrus_blogstats');

        // This registers our optional widget control form. Because of this
        // our widget will have a button that reveals a 300x100 pixel form.
        register_widget_control('Citrus blogstats', 'widget_citrus_blogstats_control', 300, 100);


?>