<?php
$templatePath = get_bloginfo("template_directory");

require_once('style-switcher.php');
// ========================================================================
// prepare scheme stylesheet switcher
$styleSheet = new AlternateStyles();
$styleSheet->add($templatePath.'/style.css','screen,projection');
$preferredScheme = get_option('bb_scheme');

$useSchemeSwitcher = get_option('bb_schemeswitcher');
define('USE_SCHEME_SWITCHER', $useSchemeSwitcher);
if (USE_SCHEME_SWITCHER == 0)
{
	// no scheme selected, so default has to be used
	if ($preferredScheme == "")
		$styleSheet->add($templatePath.'/Default.css','screen,projection','Default');

	// get available schemes
	$scheme_dir = @ dir(ABSPATH . '/wp-content/themes/' . get_template() . '/schemes');
	if ($scheme_dir) {
		while(($file = $scheme_dir->read()) !== false) {
	  		if (!preg_match('|^\.+$|', $file) && preg_match('|\.scheme\.css$|', $file))
				$scheme_files[] = $file;
		}
	}

	// process schemes that can be switched
	if ($scheme_dir || $scheme_files)
	{
		foreach($scheme_files as $scheme_file)
		{
			$styleTitle = preg_replace("|\.scheme\.css$|","" ,$scheme_file);
			$scheme_file = rawurlencode($scheme_file);
			if (strcmp($styleTitle,$preferredScheme) == 0)
			{
				$styleSheet->add($templatePath.'/schemes/'.$scheme_file,'screen,projection',$styleTitle);
			} else {
				$styleSheet->add($templatePath.'/schemes/'.$scheme_file,'screen,projection',$styleTitle,true);
			}
		}
	}
} else {
	// no switch, so the default scheme has to be used
	$styleSheet->add($templatePath.bb_info('scheme'),'screen,projection');
}
$styleSheet->getPreferredStyles();
// ========================================================================
$blogName = get_bloginfo("name");
$blogDescription = get_bloginfo("description");

$authorAmount = bb_get_author_num();
define('AUTHOR_AMOUNT', $authorAmount); // make sure it is visible everywhere

$wbbls = get_option('bb_livesearch');
define('USE_LIVESEARCH', $wbbls); // make sure it is visible everywhere

$nicetitle = get_option('bb_nicetitle');
define('USE_NICETITLE', $nicetitle); // make sure it is visible everywhere

// get the primary blog language
$blog_language = get_option('bb_blog_language');
if ($blog_language == '')
	$blog_language = 'de';
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="<?php echo $blog_language; ?>" xml:lang="<?php echo $blog_language; ?>">
<head profile="http://gmpg.org/xfn/11">
<meta http-equiv="Content-Type" content="<?php bloginfo('html_type'); ?>; charset=<?php bloginfo('charset'); ?>" />
<title><?php if (function_exists('optimal_title')) { strip_tags(optimal_title("|")); echo (strip_tags($blogName));} else {echo (strip_tags($blogName)); }?></title>
<meta name="generator" content="WordPress <?php bloginfo('version'); ?> + WP Binary Blue <?php echo bb_info('version'); ?>" />
<meta http-equiv="expires" content="0" />
<meta name="publisher" content="CountZero" />
<meta name="language" content="<?php echo $blog_language; ?>" />
<meta http-equiv="content-language" content="<?php echo $blog_language; ?>" />
<meta name="description" content="<?php echo $blogDescription; ?>" />
<meta name="author" content="CountZero" />
<meta name="copyright" content="Theme and Design Copyright Carsten Albrecht, Neukirchen-Vluyn, Germany, created 2005" />
<meta name="MSSmartTagsPreventParsing" content="true" />
<meta name="robots" content="index, follow" />
<meta name="revisit-after" content="7 days" />
<link rel="alternate" type="application/rss+xml" title="RSS 2.0: Artikel" href="<?php bloginfo('rss2_url'); ?>" />
<link rel="alternate" type="text/xml" title="RSS .92: Artikel" href="<?php bloginfo('rss_url'); ?>" />
<link rel="alternate" type="application/atom+xml" title="Atom 0.3: Artikel" href="<?php bloginfo('atom_url'); ?>" />
<?php if (is_single() or is_page()) { ?>
<link rel="pingback" href="<?php bloginfo('pingback_url'); ?>" />
<link rel="shortcut icon" href="<?php echo $templatePath; ?>/images/favicon.ico" />
<?php } ?>
<?php wp_get_archives('type=monthly&format=link'); ?>
<?php
// vorbereitete Stylesheet-URLs einrendern
$styleSheet->drop();
?>
<script type="text/javascript" src="<?php echo $templatePath; ?>/js/prototype.js"></script>
<script type="text/javascript" src="<?php echo $templatePath; ?>/js/effects.js"></script>
<script type="text/javascript" src="<?php echo $templatePath; ?>/js/behaviour.js"></script>
<script type="text/javascript" src="<?php echo $templatePath; ?>/js/themeBehaviours.js"></script>
<script type="text/javascript" src="<?php echo $templatePath; ?>/js/bbfunctions.js"></script>
<?php if (USE_SCHEME_SWITCHER == 0) { ?>
<script type='text/javascript' src='<?php echo $templatePath; ?>/js/alternateStyles.js'></script>
<?php } ?>
<?php if (USE_NICETITLE == 0) { ?>
<script type="text/javascript" src="<?php echo $templatePath; ?>/js/nicetitles.js"></script>
<?php } ?>
<?php if ((get_option('bb_livecomments')==0) and (is_single()|| is_page())) { ?>
<script type="text/javascript" src="<?php echo $templatePath; ?>/js/ajax_comments.js"></script>
<?php } ?>
<?php if ((USE_LIVESEARCH == 0) || (function_exists('dynamic_sidebar') && is_active_widget('widget_livesearch'))) { ?>
<script type="text/javascript" src="<?php echo $templatePath; ?>/js/livesearch.js"></script>
<?php } ?>
<script type="text/javascript">//<![CDATA[
	function pageInit()
	{
<?php if (USE_NICETITLE == 0) { ?>
		sweetTitles.init();
<?php } else { ?>
		sweetTitles = false;
<?php } ?>
<?php if (!is_user_logged_in() && (is_single() || is_page()) && ($comment_author = $_COOKIE['comment_author_'.COOKIEHASH]) && ('open' == $post->comment_status)) { ?>
		HideUtils(); // hide unneeded comment fields if usercookie present
<?php } ?>
<?php if (USE_SCHEME_SWITCHER == 0) { ?>
		altStyles.init(); // enable Styleswitcher
<?php } ?>
<?php if ((USE_LIVESEARCH == 0) || (function_exists('dynamic_sidebar') && is_active_widget('widget_livesearch'))) { ?>
		liveSearchInit();
<?php } ?>
		// add your further init functions that should be executed onLoad here
		Behaviour.apply();
		initLightbox();
	}
<?php if ((USE_LIVESEARCH == 0) || (function_exists('dynamic_sidebar') && is_active_widget('widget_livesearch'))) { ?>
	var liveSearchURI = "<?php echo $templatePath; ?>/livesearch.php?s=";
<?php } ?>
	// init URL for AJAX enhanced ReadMore links
	var singlePostURL = '<?php echo $templatePath; ?>/single_content.php?p=';
	var pagedCommentsURL = '<?php echo $templatePath; ?>/comments-paged.php?<?php if (is_single()) {echo "p=";} else { echo "page_id=";} ?>';
	// LightBox JS Configuration
	// If you would like to use a custom loading image or close button reference them in the next two lines.
	var fileLoadingImage        = "<?php echo $templatePath; ?>/images/loading.gif";
	var fileBottomNavCloseImage = "<?php echo $templatePath; ?>/images/close.gif";
//	var closeButton  						= "<?php echo $templatePath; ?>/images/close.gif";
//	var expandImage  						= "<?php echo $templatePath; ?>/images/expand.gif";
//	var shrinkImage  						= "<?php echo $templatePath; ?>/images/shrink.gif";
	var throbberURL  						= "<?php echo $templatePath; ?>/images/throbber.gif";
	window.onload = pageInit;
//]]></script>

<!-- MSIE older than v7 need special handling -->
<!--[if lt IE 7]>
<?php if (get_option('bb_ie7support') == 0) { ?>
  <script src="<?php echo $templatePath; ?>/js/ie7/ie7-standard-p.js" type="text/javascript"></script>
	<noscript>&nbsp;</noscript>
<?php } ?>
  <style type="text/css">
  pre {
  	width: 90%;
  }
  </style>
<![endif]-->
<?php wp_head(); ?>
</head>
<body class="bb" lang="<?php echo $blog_language; ?>" xml:lang="<?php echo $blog_language; ?>"<?php if (get_option('permalink_structure') != '' && is_page()) { echo ' id="'.get_query_var('name').'"'; } ?>>
<a name="topmost" href="#"></a>
<div id="page"><!-- the page //-->
<div id="shadowLeft"><!-- left shadow //-->
<div id="shadowRight"><!-- right shadow //-->
<div id="innerPage">

  <div id="header">
    <h1 class="topBanner"><span class="hidden"><?php _e('Seitentitel: ', '4null4.de'); ?></span><a href="<?php echo get_settings('home'); ?>"><?php echo $blogName; ?></a></h1>
    <div class="description"><?php echo $blogDescription; ?></div>

<?php if (get_option('bb_sidebar_pages') != 0) { ?>
	  <div id="topMenu">
			<ul class="menu">
				<li class="<?php if (((is_home()) && !(is_paged())) or (is_archive()) or (is_single()) or (is_paged()) or (is_search())) { ?>current_page_item<?php } else { ?>page_item<?php } ?>"><a href="<?php echo get_settings('home'); ?>" accesskey="1"><?php _e('Blog', '4null4.de'); ?></a></li>
				<?php wp_list_pages('sort_column=menu_order&depth=1&title_li='); ?>
				<?php wp_register('<li>','</li>'); ?>
				<li><?php wp_loginout(); ?></li>
			</ul>
		</div>
<?php } ?>
  </div>

  <hr class="hidden" />
	<p class="hidden"><?php _e('Schnellnavigation:', '4null4,de'); ?> <a href="#topmost"><?php _e('Zum Seitenanfang springen', '4null4.de'); ?></a> | <a href="#posts"><?php _e('Zu den Artikeln springen', '4null4.de'); ?></a> | <a href="#sidebaranchor"><?php _e('Zur Navigation springen', '4null4.de'); ?></a></p>
  <hr class="hidden" />
