<?php
require_once('../../../wp-config.php');

global $comment, $comments, $post, $wpdb, $user_ID, $user_identity, $user_email, $user_url;

function fail($s) {
	header('HTTP/1.0 500 Internal Server Error');
	echo $s;
	exit;
}

$comment_post_ID = (int) $_POST['comment_post_ID'];

$status = $wpdb->get_row("SELECT post_status, comment_status FROM $wpdb->posts WHERE ID = '$comment_post_ID'");

if ( empty($status->comment_status) ) {
	do_action('comment_id_not_found', $comment_post_ID);
	fail('The post you are trying to comment on does not curently exist in the database.');
} elseif ( 'closed' ==  $status->comment_status ) {
	do_action('comment_closed', $comment_post_ID);
	fail(__('Sorry, comments are closed for this item.'));
}

$comment_author       = trim($_POST['author']);
$comment_author_email = trim($_POST['email']);
$comment_author_url   = trim($_POST['url']);
$comment_content      = trim($_POST['comment']);

// If the user is logged in
get_currentuserinfo();
if ( $user_ID ) :
	$comment_author       = $wpdb->escape($user_identity);
	$comment_author_email = $wpdb->escape($user_email);
	$comment_author_url   = $wpdb->escape($user_url);
else :
	if ( get_option('comment_registration') )
		fail(__('Sorry, you must be logged in to post a comment.'));
endif;

$comment_type = '';

if ( get_settings('require_name_email') && !$user_ID ) {
	if ( 6 > strlen($comment_author_email) || '' == $comment_author )
		fail(__('Error: please fill the required fields (name, email).'));
	elseif ( !is_email($comment_author_email))
		fail(__('Error: please enter a valid email address.'));
}

if ( '' == $comment_content )
	fail(__('Error: please type a comment.'));

$commentdata = compact('comment_post_ID', 'comment_author', 'comment_author_email', 'comment_author_url', 'comment_content', 'comment_type', 'user_ID');

// Simple duplicate check
$dupe = "SELECT comment_ID FROM $wpdb->comments WHERE comment_post_ID = '$comment_post_ID' AND ( comment_author = '$comment_author' ";
if ( $comment_author_email )
	$dupe .= "OR comment_author_email = '$comment_author_email' ";
$dupe .= ") AND comment_content = '$comment_content' LIMIT 1";
if ( $wpdb->get_var($dupe) )
	fail( __('Duplicate comment detected; it looks as though you\'ve already said that!') );

// dupecheck passed, save comment
$newCommentId = wp_new_comment($commentdata);

if ( !$user_ID ) :
	setcookie('comment_author_' . COOKIEHASH, stripslashes($comment_author), time() + 30000000, COOKIEPATH, COOKIE_DOMAIN);
	setcookie('comment_author_email_' . COOKIEHASH, stripslashes($comment_author_email), time() + 30000000, COOKIEPATH, COOKIE_DOMAIN);
	setcookie('comment_author_url_' . COOKIEHASH, stripslashes($comment_author_url), time() + 30000000, COOKIEPATH, COOKIE_DOMAIN);
endif;

$comment = $wpdb->get_row("SELECT * FROM {$wpdb->comments} WHERE comment_ID = ".$newCommentId);

$comments = array($comment);
foreach ($comments as $comment)
{ 
	$post->comment_status = $wpdb->get_var("SELECT comment_status FROM {$wpdb->posts} WHERE ID = {$comment_post_ID}");

	$commentout = "<li class=\"comment\" id=\"comment-".get_comment_ID()."\" style=\"display:none\">"
	            . "<h2 class=\"itemFooter\">".__("Tube Senf von ", "4null4.de").get_comment_author_link()."</h2>"
	  					.	"<p><small class=\"commentmetadata\"><a href=\"#comment-".get_comment_ID()."\" title=\"\">#".__("neu ", "4null4.de")
	  					. get_comment_date('j. F Y').", ".get_comment_time().__(" Uhr", "4null4.de")."</a></small></p>"
	  					. get_comment_text();
	
	if ($comment->comment_approved == '0')
	{
		$commentout .= "<p><em>".__("Ihre Tube Senf wartet in der Moderation auf Freischaltung.", "4null4.de")."</em></p>";
	}
	$commentout .= "</li>";


}
echo $commentout;
?>
