<?php
$themename = "Press Box";
$shortname = "box";
$options = array (
    
    

		    array(    "name" => "How to list things",
		            "id" => $shortname."_functionality",
		            "type" => "select",
		            "std" => "Show images with text previews",
		            "options" => array("PressBox Standard", "Normal Blog Style")), 
				    array(    "name" => "What kind of header to have",
				            "id" => $shortname."_headerstyle",
				            "type" => "select",
				            "std" => "Textual header",
				            "options" => array("Textual header", "Custom image header", "No header necessary")),
				    array(    "name" => "How the blog should look",
				            "id" => $shortname."_paintstyle",
				            "type" => "select",
				            "std" => "Simple and clean",
				            "options" => array("Simple and clean", "High contrast", "Dark and dim"))
);

function pressbox_add_admin() {

    global $themename, $shortname, $options;

    if ( $_GET['page'] == basename(__FILE__) ) {
    
        if ( 'save' == $_REQUEST['action'] ) {

                foreach ($options as $value) {
                    update_option( $value['id'], $_REQUEST[ $value['id'] ] ); }

                foreach ($options as $value) {
                    if( isset( $_REQUEST[ $value['id'] ] ) ) { update_option( $value['id'], $_REQUEST[ $value['id'] ]  ); } else { delete_option( $value['id'] ); } }

                header("Location: themes.php?page=functions.php&saved=true");
                die;

        } else if( 'reset' == $_REQUEST['action'] ) {

            foreach ($options as $value) {
                delete_option( $value['id'] ); }

            header("Location: themes.php?page=functions.php&reset=true");
            die;

        }
    }

    add_theme_page($themename." Options", "PressBox Options", 'edit_themes', basename(__FILE__), 'pressbox_admin');

}

function pressbox_admin() {

    global $themename, $shortname, $options;

    if ( $_REQUEST['saved'] ) echo '<div id="message" class="updated fade"><p><strong>'.$themename.' settings saved.</strong></p></div>';
    if ( $_REQUEST['reset'] ) echo '<div id="message" class="updated fade"><p><strong>'.$themename.' settings reset.</strong></p></div>';
    
?>
<div class="wrap" >
<h2><?php echo $themename; ?> settings</h2>
For additional information, please visit the <a href="http://www.creativesynthesis.net/blog/projects/web-commodities/press-box/">Press Box</a> site.<br/><br/>
<form method="post">

<table class="optiontable">

<?php foreach ($options as $value) { 
    
if ($value['type'] == "text") { ?>
        
<tr valign="top"> 
    <th scope="row"><?php echo $value['name']; ?>:</th>
    <td>
        <input name="<?php echo $value['id']; ?>" id="<?php echo $value['id']; ?>" type="<?php echo $value['type']; ?>" value="<?php if ( get_settings( $value['id'] ) != "") { echo get_settings( $value['id'] ); } else { echo $value['std']; } ?>" />
    </td>
</tr>

<?php } elseif ($value['type'] == "select") { ?>

    <tr valign="top"> 
        <th scope="row"><?php echo $value['name']; ?>:</th>
		
        <td>
            <select name="<?php echo $value['id']; ?>" id="<?php echo $value['id']; ?>">
                <?php foreach ($value['options'] as $option) { ?>
                <option<?php if ( get_settings( $value['id'] ) == $option) { echo ' selected="selected"'; } elseif ($option == $value['std']) { echo ' selected="selected"'; } ?>><?php echo $option; ?></option>
                <?php } ?>
            </select>
        </td>
    </tr>

<?php 
} 
}

?>

</table>

<p class="submit">
<input name="save" type="submit" value="Save changes" />    
<input type="hidden" name="action" value="save" />
</p>
</form>
<form method="post">
<p class="submit">
<input name="reset" type="submit" value="Reset" />
<input type="hidden" name="action" value="reset" />
</p>
</form>

<?php
}
add_action('admin_menu', 'pressbox_add_admin'); 



/* Widgetized Sidebar Support */


if ( function_exists('register_sidebar') )
register_sidebar(array('name'=>'sidebar',
'before_widget' => '<div id="%1$s" class="widget %2$s">',
'after_widget' => '</div>',
'before_title' => '<h4>',
'after_title' => '</h4>',
));
register_sidebar(array('name'=>'minibar',
    'before_widget' => '<div id="%1$s" class="widget %2$s">',
    'after_widget' => '</div>',
'before_title' => '<h4>',
'after_title' => '</h4>',
));


/* Helper Get Functions */


function ChunkTitle() {
	// Seperate first word of title
	$titleChunks = explode(" ", get_bloginfo('name'));
	$titleFront = $titleChunks[0];
	$titleChunks = array_slice($titleChunks,1);
	$titleRest = implode(" ", $titleChunks);
	$title['front'] = $titleFront;
	$title['rest'] = $titleRest;
	
	return $title;
}
function ImportPaintStyle() {
	global $options;
	foreach ($options as $value) {
	    if (get_settings( $value['id'] ) === FALSE) { $$value['id'] = $value['std']; } else { $$value['id'] = get_settings( $value['id'] ); } }
	
	if($box_paintstyle == "High contrast") { echo "<link rel=\"stylesheet\" type=\"text/css\" media=\"screen\" href=\"" . get_bloginfo('template_url') . "/themes/contrast/contrast-theme.css\" />";}
	else if($box_paintstyle == "Dark and dim") { echo "<link rel=\"stylesheet\" type=\"text/css\" media=\"screen\" href=\"" . get_bloginfo('template_url') . "/themes/dark/dark-theme.css\" />";}
	else if($box_paintstyle == "Professional blue") { echo "<link rel=\"stylesheet\" type=\"text/css\" media=\"screen\" href=\"" . get_bloginfo('template_url') . "/themes/bluish/bluish-theme.css\" />";}	
	else { }    
}
function ListFunctionality() {
	global $options;
	foreach ($options as $value) {
	    if (get_settings( $value['id'] ) === FALSE) { $$value['id'] = $value['std']; } else { $$value['id'] = get_settings( $value['id'] ); } }
	
	if($box_functionality == "PressBox Standard") { return '/includes/articleloop.php';}
	else if($box_functionality == "Normal Blog Style") { return '/includes/fullloop.php';}
	else if($box_functionality == "PressBox Portfolio") { return '/includes/imageloop.php';}	
	else { return '/includes/articleloop.php';}    
}
function GetFunctionality() {
	global $options;
	foreach ($options as $value) {
	    if (get_settings( $value['id'] ) === FALSE) { $$value['id'] = $value['std']; } else { $$value['id'] = get_settings( $value['id'] ); } }
	
	if($box_functionality == "Show images with text previews") { return 'article';}
	else if($box_functionality == "Normal Blog Style") { return 'full';}
	else if($box_functionality == "PressBox Portfolio") { return 'image';}	
	else { return 'article';}    
}
function GetHeaderType() {
	global $options;
	foreach ($options as $value) {
	    if (get_settings( $value['id'] ) === FALSE) { $$value['id'] = $value['std']; } else { $$value['id'] = get_settings( $value['id'] ); } }
	
	if($box_headerstyle == "Textual header") { return 'text';}
	else if($box_headerstyle == "Custom image header") { return 'image';}
	else if($box_headerstyle == "No header necessary") { return 'none';}	
	else { return 'text';}    
}
function box_prettyrss($args) {
	if($args != "mini") {
	echo '<h4>Feed Subscriptions</h4>
	<p><img src="' . get_bloginfo('template_url') . '/images/feed-icon-28x28.png" alt="RSS Feed" class="left padded"/><a href="' . get_bloginfo('rss2_url') . '">Subscribe to Things</a><br/><a href="' .  get_bloginfo('comments_rss2_url') . '">Subscribe to Comments</a></p>';
} else {
	echo '<h4>Feed Subscriptions</h4>
	<p><img src="' . get_bloginfo('template_url') . '/images/feed-icon-28x28.png" alt="RSS Feed" class="left padded"/><a href="' . get_bloginfo('rss2_url') . '">RSS Things</a><br/><a href="' .  get_bloginfo('comments_rss2_url') . '">RSS Comments</a></p>';
}
}
function box_shortthings() {
	global $post;
	echo '<div class="short-things"><h4>Short Things</h4>';
	$my_query = new WP_Query('category_name=asides&showposts=5'); 
	while ($my_query->have_posts()) : $my_query->the_post(); 
	echo '<p><a href="' . get_permalink() . '">' . the_title('','', false) . '</a><br/>' . $post->post_content . '</p>';
	endwhile;
	echo '</div>';
}
/* Custom Widgets */
register_sidebar_widget('Pretty RSS', 'box_prettyrss');
register_sidebar_widget('Short Things', 'box_shortthings');





/* Bundled Plugins */

/* The Post Image Plugin, edited slightly */
include_once ("functions/htmlParser.php");
include_once ("functions/class.ImageToolbox.php");

function get_image() {
	global $post, $destinationDir;

	if (!empty($post->post_password)) { // if there's a password
		if ($_COOKIE['wp-postpass_'.COOKIEHASH] != $post->post_password) { // and it doesn't match cookie
			if(is_feed()) { // if this runs in a feed
				$output = __('There is no excerpt because this is a protected post.');
			} else {
	            $output = get_the_password_form();
			}
		}
		return $output;
	}

	$text = $post->post_content;

  // Create the parser
  $parser = new htmlparser_class;
  
  // Set the html code
  $ret=$parser->InsertHTML($text);
  if ($ret===false) return;
  $parser->Parse();
  $result=$parser->GetElements($htmlCode);
  $attribArr=$parser->getTagResource("img");    
  if ($attribArr==false) return "";
  $ret="";

  if (is_array($attribArr[0]))
  foreach ($attribArr[0] as $k=>$v) {
	if ($k=="align") continue;
	if ($k=="alt") continue;	
    $ret.=" ".$k."=\"".$v."\"";
  }
  $alt = "(preview-image)";
  $ret.=" alt=\"".$alt."\"";
  $output="<img ".$ret."/>";
  
  
	$output = apply_filters($filter_type, $output);	

	return $output;
}

function get_image_thumb() {
	global $post, $destinationDir;

	if (!empty($post->post_password)) { // if there's a password
		if ($_COOKIE['wp-postpass_'.COOKIEHASH] != $post->post_password) { // and it doesn't match cookie
			if(is_feed()) { // if this runs in a feed
				$output = __('There is no excerpt because this is a protected post.');
			} else {
	            $output = get_the_password_form();
			}
		}
		return $output;
	}

	$text = $post->post_content;

  // Create the parser
  $parser = new htmlparser_class;
  
  // Set the html code
  $ret=$parser->InsertHTML($text);
  if ($ret===false) return;
  $parser->Parse();
  $result=$parser->GetElements($htmlCode);
  $attribArr=$parser->getTagResource("img");    
  if ($attribArr==false) return "";
  $ret="";

  if (is_array($attribArr[0]))
  foreach ($attribArr[0] as $k=>$v) {
	if ($k=="align") continue;
	if ($k=="alt") continue;
	if ($k=="width") continue;
	if ($k=="height") continue;
	if ($k=="src") {
		$front = substr($v, 0, strlen($v)-4); $back = substr($v, -4);
		$testurl = $front . ".thumbnail" . $back;
		$size = @getimagesize($testurl);
		if($size){
			$v = $testurl;			
		}
		
	}
	
    $ret.=" ".$k."=\"".$v."\"";
  }
  $alt = "(preview-image)";
  $ret.=" alt=\"".$alt."\"";
  $output="<img ".$ret."/>";
  
  
	$output = apply_filters($filter_type, $output);

	return $output;
}

function missing_box_postimage($postID) {
	global $wpdb;
	//get the post content and title
	$content = $wpdb->get_row("SELECT post_content, post_title FROM $wpdb->posts WHERE ID = $postID", ARRAY_A);


	//check to see if the field is set
	$metaid = $wpdb->get_var("SELECT meta_id FROM $wpdb->postmeta WHERE post_id=$postID AND meta_key='box-postimage' limit 1");
	if (is_null($metaid)) {
		return true;
	} 
	else {return false;}
}

function set_box_postimage($postID, $imageurl) {
	//then insert if empty
		$wpdb->query("INSERT INTO $wpdb->postmeta (post_id, meta_key, meta_value) VALUES ($postID, 'box-postimage', $imageurl)");
	
}
/* The Excerpt Reloaded, edited slightly */

function wp_the_excerpt_reloaded($args='') {
	parse_str($args);
	if(!isset($excerpt_length)) $excerpt_length = 120; // length of excerpt in words. -1 to display all excerpt/content
	if(!isset($allowedtags)) $allowedtags = '<a>'; // HTML tags allowed in excerpt, 'all' to allow all tags.
	if(!isset($filter_type)) $filter_type = 'none'; // format filter used => 'content', 'excerpt', 'content_rss', 'excerpt_rss', 'none'
	if(!isset($use_more_link)) $use_more_link = 1; // display
	if(!isset($more_link_text)) $more_link_text = "(more...)";
	if(!isset($force_more)) $force_more = 1;
	if(!isset($fakeit)) $fakeit = 1;
	if(!isset($fix_tags)) $fix_tags = 1;
	if(!isset($no_more)) $no_more = 0;
	if(!isset($more_tag)) $more_tag = 'div';
	if(!isset($more_link_title)) $more_link_title = 'Continue reading this entry';
	if(!isset($showdots)) $showdots = 1;

	return the_excerpt_reloaded($excerpt_length, $allowedtags, $filter_type, $use_more_link, $more_link_text, $force_more, $fakeit, $fix_tags, $no_more, $more_tag, $more_link_title, $showdots);
}

function the_excerpt_reloaded($excerpt_length=120, $allowedtags='<a>', $filter_type='none', $use_more_link=true, $more_link_text="(more...)", $force_more=true, $fakeit=2, $fix_tags=true, $no_more=false, $more_tag='div', $more_link_title='Continue reading this entry', $showdots=true) {
	if(preg_match('%^content($|_rss)|^excerpt($|_rss)%', $filter_type)) {
		$filter_type = 'the_' . $filter_type;
	}
	echo get_the_excerpt_reloaded($excerpt_length, $allowedtags, $filter_type, $use_more_link, $more_link_text, $force_more, $fakeit, $no_more, $more_tag, $more_link_title, $showdots);
}

function get_the_excerpt_reloaded($excerpt_length, $allowedtags, $filter_type, $use_more_link, $more_link_text, $force_more, $fakeit, $no_more, $more_tag, $more_link_title, $showdots) {
	global $post;

	if (!empty($post->post_password)) { // if there's a password
		if ($_COOKIE['wp-postpass_'.COOKIEHASH] != $post->post_password) { // and it doesn't match cookie
			if(is_feed()) { // if this runs in a feed
				$output = __('There is no excerpt because this is a protected post.');
			} else {
	            $output = get_the_password_form();
			}
		}
		return $output;
	}

	if($fakeit == 2) { // force content as excerpt
		$text = $post->post_content;
	} elseif($fakeit == 1) { // content as excerpt, if no excerpt
		$text = (empty($post->post_excerpt)) ? $post->post_content : $post->post_excerpt;
	} else { // excerpt no matter what
		$text = $post->post_excerpt;
	}
	
	if('all' != $allowed_tags) {
		$text = strip_tags($text, $allowedtags);
	}
	

	if($excerpt_length < 0) {
		$output = $text;
	} else {
		if(!$no_more && strpos($text, '<!--more-->')) {
		    $text = explode('<!--more-->', $text, 2);
			$l = count($text[0]);
			$more_link = 1;
		} else {
			$text = explode(' ', $text);
			if(count($text) > $excerpt_length) {
				$l = $excerpt_length;
				$ellipsis = 1;
			} else {
				$l = count($text);
				$more_link_text = '';
				$ellipsis = 0;
			}
		}
		for ($i=0; $i<$l; $i++)
				$output .= $text[$i] . ' ';
	}



//	$output = str_replace(array("\r\n", "\r", "\n", "  "), " ", $output);

	$output = rtrim($output, "\s\n\t\r\0\x0B");
	$output = ($fix_tags) ? $output : balanceTags($output);
	$output .= ($showdots && $ellipsis) ? '...' : '';

	switch($more_tag) {
		case('div') :
			$tag = 'div';
		break;
		case('span') :
			$tag = 'span';
		break;
		case('p') :
			$tag = 'p';
		break;
		default :
			$tag = 'span';
	}

	if ($use_more_link && $more_link_text) {
		if($force_more) {
			$output .= ' <' . $tag . ' class="more-link"><a href="'. get_permalink($post->ID) . '#more-' . $post->ID .'" title="' . $more_link_title . '">' . $more_link_text . '</a></' . $tag . '>' . "\n";
		} else {
			$output .= ' <' . $tag . ' class="more-link"><a href="'. get_permalink($post->ID) . '" title="' . $more_link_title . '">' . $more_link_text . '</a></' . $tag . '>' . "\n";
		}
	}

	$output = apply_filters($filter_type, $output);

	return $output;
}

/* Weighted Tags, edited slightly */

function weighted_categories($smallest=8, $largest=12, $unit="pt", $exclude='')
{
	$args= array(
	           'show_option_all' => '0',
	           'orderby' => 'name',
			       'order' => 'ASC',
	           'show_last_update' => 0,
	           'style' => 'list',
			       'show_count' => 0, 
	           'hide_empty' => 0, 
	           'use_desc_for_title' => 1,
			       'child_of' => 0, 
	           'feed' => '', 
	           'feed_image' => '', 
	           'exclude' => $exclude,
	           'hierarchical' => true, 
	           'title_li' => __('Categories')
	           );

	$cats = get_categories($args);
	foreach ($cats as $cat)
	{

		$catlink = get_category_link($cat->cat_ID);
		$catname = $cat->cat_name; $count = $cat->category_count;
		if($count > 0) {
			$counts{$catname} = $count;
			$catlinks{$catname} = $catlink;
		}
	}
	
	$spread = max($counts) - min($counts); 
	if ($spread <= 0) { $spread = 1; };
	$fontspread = $largest - $smallest;
	$fontstep = $spread / $fontspread;
	if ($fontstep <= 1) { $fontstep = 1; }	
	
	if ($fontspread <= 0) { $fontspread = 1; }
	foreach ($counts as $catname => $count)
	{
		$catlink = $catlinks{$catname};
		print "<a href=\"$catlink\" title=\"$count entries\" style=\"font-size: ".
		($smallest + ($count/$fontstep))."$unit;\">$catname</a> \n";
	}
}

?>