	<div id="primary" class="sidebar">
		<ul>
<?php if (!function_exists('dynamic_sidebar') || !dynamic_sidebar() ) :  ?>

<?php if ( !is_home() || is_paged() ) { ?>
			<li id="home-link">
				<h3><a href="<?php bloginfo('home') ?>" title="<?php echo wp_specialchars(get_bloginfo('name'), 1) ?>"><?php _e('Home', 'barthelme'); ?></a></h3>
			</li>
<?php } ?>

<?php wp_list_pages('title_li=<h3>'.__('Pages').'</h3>&sort_column=post_title' ) ?>

			<li id="categories">
				<h3><?php _e('Categories', 'barthelme'); ?></h3>
				<ul>
<?php wp_list_cats('sort_column=name&hierarchical=1') ?>

				</ul>
			</li>

<?php widget_barthelme_links() ?>

			<li id="feed-links">
				<h3><?php _e('RSS Feeds', 'barthelme') ?></h3>
				<ul>
					<li><a href="<?php bloginfo('rss2_url') ?>" title="<?php echo wp_specialchars(get_bloginfo('name'), 1) ?> RSS 2.0 Feed" rel="alternate" type="application/rss+xml"><?php _e('All posts', 'barthelme') ?></a></li>
					<li><a href="<?php bloginfo('comments_rss2_url') ?>" title="<?php echo wp_specialchars(bloginfo('name'), 1) ?> Comments RSS 2.0 Feed" rel="alternate" type="application/rss+xml"><?php _e('All comments', 'barthelme') ?></a></li>
				</ul>
			</li>

			<li id="meta">
				<h3><?php _e('Meta', 'barthelme') ?></h3>
				<ul>
					<?php wp_register() ?>
					<li><?php wp_loginout() ?></li>
					<?php wp_meta() ?>
				</ul>
			</li>

			<li id="search">
				<h3><label for="s"><?php _e('Blog Search', 'barthelme') ?></label></h3>
				<form id="searchform" method="get" action="<?php bloginfo('home') ?>">
					<div>
						<input id="s" name="s" type="text" value="<?php echo wp_specialchars(stripslashes($_GET['s']), true) ?>" size="10" />
						<input id="searchsubmit" name="searchsubmit" type="submit" value="<?php _e('Search', 'barthelme') ?>" />
					</div>
				</form>
			</li>
<?php endif; ?>

		</ul>
	</div>
