<?php

function get_sidebar_right() {
	do_action( 'get_sidebar' );
	if ( file_exists( TEMPLATEPATH . '/sidebar_right.php') )
		load_template( TEMPLATEPATH . '/sidebar_right.php');
	else
		load_template( ABSPATH . 'wp-content/themes/default/sidebar.php');
}

function wp_list_pages2($limit=NULL) {
	
	$defaults = array('depth' => 0, 'show_date' => '', 'date_format' => get_option('date_format'),
		'child_of' => 0, 'exclude' => '', 'title_li' =>'', 'echo' => 1, 'authors' => '', 'sort_column' => 'menu_order, post_title');
	$r = array_merge((array)$defaults, (array)$r);

	$output = '';
	$current_page = 0;

	// sanitize, mostly to keep spaces out
	$r['exclude'] = preg_replace('[^0-9,]', '', $r['exclude']);

	// Allow plugins to filter an array of excluded pages
	$r['exclude'] = implode(',', apply_filters('wp_list_pages_excludes', explode(',', $r['exclude'])));

	// Query pages.
	$pages = get_pages($r);

	if ( !empty($pages) ) {

		for($i=0;$i<count($pages);$i++)
		{
			$output .='<div><a href="'.get_page_link($pages[$i]->ID).'">'.strtoupper($pages[$i]->post_title).'</a></div>';
			if($limit!=NULL)
			{
				break;
			}
		}
	}

	$output = apply_filters('wp_list_pages', $output);

	echo $output;
}



function get_links_list2($order = 'name', $hide_if_empty = 'obsolete') {
	$order = strtolower($order);

	// Handle link category sorting
	$direction = 'ASC';
	if ( '_' == substr($order,0,1) ) {
		$direction = 'DESC';
		$order = substr($order,1);
	}

	if ( !isset($direction) )
		$direction = '';

	$cats = get_categories("type=link&orderby=$order&order=$direction&hierarchical=0");

	// Display each category
	if ( $cats ) {
		foreach ( (array) $cats as $cat ) {
			// Handle each category.

			// Call get_links() with all the appropriate params
			get_links($cat->cat_ID, '<li>', "</li>", "\n", true, 'name', false);

			// Close the last category
		}
	}
}

if ( function_exists('register_sidebar') )
{
	register_sidebar(array('name'=>'Sidebar 1'));
	register_sidebar(array('name'=>'Sidebar 2'));
}

?>
