<?php get_header(); ?>

	<?php if (have_posts()) : ?>

		<?php while (have_posts()) : the_post(); ?>

			<div class="post" id="post-<?php the_ID(); ?>">
				<h2><a href="<?php the_permalink() ?>" rel="bookmark" title="Permanent Link to <?php the_title_attribute(); ?>"><?php the_title(); ?></a></h2>
				<div class="meta">Posted by <?php the_author() ?> in <?php the_category(', ') ?> on <?php the_time('F jS, Y') ?> <?php edit_post_link('Edit', ' | '); ?></div>

				<div class="entry">
					<?php the_content('Read the rest of this entry &raquo;'); ?>
				</div>

				<div class="tags"><?php the_tags(__('Tags: '), ', '); ?></div> 

				<div class="comments"><?php comments_popup_link('No Comments', '1 Comment', '% Comments'); ?></div>
  
			</div>

		<?php endwhile; ?>

		<?php posts_navigation(); ?>

	<?php else : ?>

		<h2 class="center">Not Found</h2>
		<p class="center">Sorry, but you are looking for something that isn't here.</p>
		<?php include (TEMPLATEPATH . "/searchform.php"); ?>

	<?php endif; ?>

<?php get_footer(); ?>
