<?php
	require('./wp-blog-header.php');
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">

<head profile="http://gmpg.org/xfn/1">
	<title><?php bloginfo('name'); ?><?php wp_title(); ?></title>
	<meta http-equiv="Content-Type" content="text/html; charset=<?php bloginfo('charset'); ?>" />
	<meta name="generator" content="WordPress <?php bloginfo('version'); ?>" />
	<style type="text/css" media="screen">@import url( <?php bloginfo('stylesheet_url'); ?> );</style>
	<link rel="alternate" type="application/rss+xml" title="RSS 2.0" href="<?php bloginfo('rss2_url'); ?>" />
	<link rel="alternate" type="application/rss+xml" title="Comments RSS 2.0" href="<?php bloginfo('comments_rss2_url'); ?>" />
	<link rel="alternate" type="text/xml" title="RSS 0.92" href="<?php bloginfo('rss_url'); ?>" />
	<link rel="alternate" type="application/atom+xml" title="Atom 0.3" href="<?php bloginfo('atom_url'); ?>" />
	<link rel="pingback" href="<?php bloginfo('pingback_url'); ?>" />
	<?php wp_get_archives('type=monthly&format=link'); ?>
	<?php wp_head(); ?>
	<link rel="shortcut icon" href="favicon.ico" />
</head>

<body>

<div id="wrapper">

	<?PHP include ("header.php"); ?>

<div id="contentwrapper">

<br /><br />

<div id="content">

	<div id="sidebar" align="right">
		<?PHP include ("sidebar.php"); ?>
	</div>

	<div id="blogs">

		<?php if (have_posts()) : while (have_posts()) : the_post(); ?>

		<div class="title" id="post-<?php the_ID(); ?>"><span><img src="<?php bloginfo('url'); ?>/wp-content/themes/arzel_xt2/images/icon_post.gif" alt="" /></span> <a href="<?php the_permalink() ?>" rel="bookmark" title="View Details: <?php the_title(); ?>"><?php the_title(); ?></a></div>
		<div class="small"><?php the_time("l j F Y @ g:i a") ?></div>

		<?php the_content("<b>read more...</b>"); ?>

		<div class="meta" align="right">
			<?php comments_popup_link(__('Comments (0)'), __('Comments (1)'), __('Comments (%)')); ?>
			- <?php _e("Posted in"); ?> <?php the_category(',') ?> by <b><?php the_author_posts_link(); ?></b> &nbsp;<?php edit_post_link(); ?>
		</div>

		<br /><hr /><br /><br />

		<!--
		<?php trackback_rdf(); ?>
		-->

		<?php comments_template(); // Get wp-comments.php template ?>

		<?php endwhile; else: ?>
		<p><?php _e('Sorry, no posts matched your criteria.'); ?></p>
		<?php endif; ?>

		<!-- start bottom blog nav -->

		<div align="center"><?php posts_nav_link('&nbsp;','<img src="wp-content/themes/arzel_xt2/images/previouspage.gif" alt="Previous Page" />','<img src="wp-content/themes/arzel_xt2/images/nextpage.gif" alt="Next Page" />'); ?></div>

	</div>
</div>

</div> <!-- end contentwrapper -->

<div id="footer">
	<?PHP include ("footer.php"); ?>
</div>

</div>
</body>
</html>