<?php if( nun_getEinstellungen( 'hinweis' ) == 1 ) { // display Informations ?>
  <?php /* If this is a category archive */ if (is_category()) { ?>

  <h2>Activity</h2><ul><li><p>You are searching within the category:
    <strong><?php single_cat_title(''); ?></strong>
    </p></li></ul>

  <?php /* If this is a yearly archive */ } elseif (is_day()) { ?>
  <h2>Activity</h2><ul><li><p>You are currently browsing the <a href="<?php echo get_settings('siteurl'); ?>"><?php echo bloginfo('name'); ?></a> weblog archives for the day
    <?php the_time('l, F jS, Y'); ?>
    .</p></li></ul>

  <?php /* If this is a monthly archive */ } elseif (is_month()) { ?>
  <h2>Activity</h2><ul><li><p>You are currently within the archive of <a href="<?php echo get_settings('siteurl'); ?>"><?php echo bloginfo('name'); ?></a> for the month
   <strong><?php the_time('F Y'); ?></strong>
    .</p></li></ul>

  <?php /* If this is a yearly archive */ } elseif (is_year()) { ?>
  <h2>Activity</h2><ul><li><p>You are currently browsing the <a href="<?php echo get_settings('siteurl'); ?>"><?php echo bloginfo('name'); ?></a> weblog archives for the year
    <?php the_time('Y'); ?>
    .</p></li></ul>

  <?php /* If this is a search */ } elseif (is_search()) { ?>
  <h2>Activity</h2><ul><li><p>You have search the website <?php echo bloginfo('name'); ?> for "<strong><?php echo wp_specialchars($s); ?></strong>".</p></li></ul>

  <?php /* If this is a monthly archive */ } elseif (isset($_GET['paged']) && !empty($_GET['paged'])) { ?>
  <h2>Currently Browsing</h2><ul><li><p>You are currently browsing the <a href="<?php echo get_settings('siteurl'); ?>"><?php echo bloginfo('name'); ?></a> weblog archives.</p></li></ul>
  
  <?php /* If this homepage */ } elseif (is_home()) { ?>
  <h2>Note</h2>
  <ul><li>Comments and hints are welcome anytime.</li></ul>


  <?php } ?>
<?php } ?>


<?php if (function_exists('wp_theme_switcher')) { ?>
<li><h2><?php _e('Themes'); ?></h2>
<?php wp_theme_switcher(); ?>
</li>
<?php } ?>


<?php if( nun_getEinstellungen( 'calendar' ) == 1 ) { // display Calendar ?>
  <div id="calendar">
    <?php get_calendar(); ?>
  </div>
<?php } ?>


<?php if( nun_getEinstellungen( 'categorie' ) == 1 ) { // display Categories ?>
<h2><?php _e('Categories'); ?></h2>
	<ul>
		<?php wp_list_cats('sort_column=name&optioncount=1&hierarchical=1');    ?>
	</ul>
<?php } ?>


<?php if( nun_getEinstellungen( 'posts' ) == 1 ) { // display recent posts ?>
<h2><?php _e('Recent Posts'); ?></h2>
	<ul>
		<?php wp_get_archives('type=postbypost&limit=10'); ?>
	</ul>
<?php } ?>


<?php if( nun_getEinstellungen( 'months' ) == 1 ) { // display monthly archiv ?>
<h2><?php _e('Archive'); ?></h2>
	<ul>
		<?php wp_get_archives('type=monthly'); ?>
	</ul>
<?php } ?>


<?php if( nun_getEinstellungen( 'arssfeed' ) == 1 ) { // display RSS-Feeds ?>
<h2>RSS-Feeds</h2>
  <ul>
    <li><a href="<?php bloginfo('rss2_url'); ?>" title="<?php _e('Syndicate this site using RSS'); ?>">
      <?php _e('<abbr title="Really Simple Syndication">RSS</abbr> 2.0'); ?></a></li>

    <li><a href="<?php bloginfo('comments_rss2_url'); ?>" title="<?php _e('The latest comments to all posts in RSS'); ?>">
      <?php _e('Comments <abbr title="Really Simple Syndication">RSS</abbr> 2.0'); ?></a></li>		
    <li>--------------------</li>
    <li><a href="http://add.my.yahoo.com/rss?url=<?php bloginfo('rss2_url'); ?>" title="Add to My Yahoo!"><img src="http://us.i1.yimg.com/us.yimg.com/i/us/my/addtomyyahoo4.gif" alt="Add to My Yahoo!" /></a></li>
    <li><a href="http://my.msn.com/addtomymsn.armx?id=rss&amp;ut=<?php bloginfo('rss2_url'); ?>&amp;tt=CENTRALDIRECTORY&amp;ru=http://rss.msn.com'"><img src="http://sc.msn.com/c/rss/rss_mymsn.gif" alt="Add to My MSN" /></a></li>
    <li><a href="http://www.bloglines.com/sub/<?php bloginfo('rss2_url'); ?>"><img src="http://www.bloglines.com/images/sub_modern1.gif" border="0" alt="Subscribe with Bloglines" /></a></li>
  </ul>
<?php } ?>


<?php if( nun_getEinstellungen( 'meta' ) == 1 ) { // display Meta ?>
<h2><?php _e('Meta'); ?></h2>
	<ul>
		<?php wp_register(); ?>
			<li><?php wp_loginout(); ?></li>
		<li><a href="/Impressum" id="navContact" title="Impressum" accesskey="c">Impressum</a></li>
		<li>--------------------</li>
			<li><a href="http://validator.w3.org/check/referer" title="Valid W3C XHTML 1.0 Transitional" target="_new">Valid XHTML 1.0</a></li>
			<li><a href="http://feedvalidator.org/check.cgi?url=<?php bloginfo('url'); ?>/feed/" title="Valid RSS 2.0" target="_new">Valid RSS 2.0</a></li>
			<li><a href="http://feedvalidator.org/check.cgi?url=<?php bloginfo('url'); ?>/feed/atom/" title="Valid Atom 0.3" target="_new">Valid Atom</a></li>
		<?php wp_meta(); ?>
	</ul>
<?php } ?>