<?php get_header(); ?>

<?php include (TEMPLATEPATH . '/left-sidebar.php'); ?>
<?php include (TEMPLATEPATH . '/right-sidebar.php'); ?>

<div class="main">

	<?php if (have_posts()) : ?>
	<?php $post = $posts[0]; // Hack. Set $post so that the_date() works. ?>

	<?php /* If this is a category archive */ if (is_category()) { ?>	
		<h5 class="pagetitle">Archive for  '<?php echo single_cat_title(); ?>' Category</h5>
	<?php /* If this is a daily archive */ } elseif (is_day()) { ?>
		<h5 class="pagetitle">Archive for <?php the_time('F jS, Y'); ?></h5>
	<?php /* If this is a monthly archive */ } elseif (is_month()) { ?>
		<h5 class="pagetitle">Archive for <?php the_time('F, Y'); ?></h5>
	<?php /* If this is a yearly archive */ } elseif (is_year()) { ?>
		<h5 class="pagetitle">Archive for <?php the_time('Y'); ?></h5>
	<?php /* If this is a search */ } elseif (is_search()) { ?>
		<h5 class="pagetitle">Search Results</h5>
	<?php /* If this is an author archive */ } elseif (is_author()) { ?>
		<h5 class="pagetitle">Author Archive</h5>
	<?php /* If this is a paged archive */ } elseif (isset($_GET['paged']) && !empty($_GET['paged'])) { ?>
		<h5 class="pagetitle">Archives</h5>
	<?php } ?>



		<p><?php posts_nav_link(' &#8212; ', __('&laquo; Previous Page'), __('Next Page &raquo;')); ?></p>

	<?php while (have_posts()) : the_post(); ?>

		<h4><a href="<?php the_permalink() ?>" rel="bookmark" title="Permanent Link a <?php the_title(); ?>"><?php the_title(); ?></a>
		<?php edit_post_link('<img src="'.get_bloginfo(template_directory).'/images/pencil.png" alt="Edit Link" />','<span class="editlink">','</span>'); ?></h4>

		<small><?php the_time('j F Y') ?> <!-- by <?php the_author() ?> --></small>
		<p><?php the_excerpt() ?></p>
		
		<div class="entrymeta">
		<div class="postinfo">
		<span class="postedby">Posted by <?php the_author() ?></span>
		<span class="filedto">Filed in <?php the_category(', ') ?></span>
		<?php comments_popup_link('No Comments &#187;', '1 Comment &#187;', '% Comments &#187;', 'commentslink'); ?>
		</div>
		</div>

		<?php endwhile; ?>
<br/>
		<p><?php posts_nav_link(' &#8212; ', __('&laquo; Previous Page'), __('Next Page &raquo;')); ?></p>

	<?php else : ?>

		<h2 class="center">Not Found</h2>

		<?php endif; ?>

	</div>

<?php get_footer(); ?>