<?php
/*
Plugin Name: PageNav Widget
Description: Adds a sidebar widget to navigate in an easy way thru child pages based on wp-pagesnav from Adi Sieker.
Author: Nico Berlee
Version: 1.0
Author URI: http://nico.berlee.nl
*/

function widget_pagenav_init() {
        if ( !function_exists('register_sidebar_widget') )
                return;

	function widget_pagenav($args) {
		extract($args);
		echo $before_widget;
		echo $before_title.'Page Navigation'.$after_title; 

/*  Copyright 2004  Adi J. Sieker  (email : adi@adsworth.info)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

    global $wp_query;
        parse_str($args, $r);
        if (!isset($r['current']))          $r['current'] = -1;
        if (!isset($r['show_all_parents'])) $r['show_all_parents'] = 0;
        if (!isset($r['show_root']))        $r['show_root'] = 0;
        if (!isset($r['maxlevel']))        $r['maxlevel'] = 3;
        if (!isset($r['list_tag']))        $r['show_root'] = 1;

    if($r['current'] == "")
        return;

    if($r['current'] == -1 && $wp_query->is_page == true) {
        $r['current'] = $wp_query->post->ID;
    }

    if($r['current'] == -1 && $r['show_root'] != 0) {
        $r['current'] = 0;
    }

        // Query pages.
        $pages = get_pages($args);
        if ( $pages ) {
        // Now loop over all pages that were selected
        $page_tree = Array();
        $parent_page_id = null;
        $parents= Array();
        foreach($pages as $page) {
                // set the title for the current page
                $page_tree[$page->ID]['title'] = $page->post_title;
                $page_tree[$page->ID]['parent'] = $page->post_parent;

                // set the selected date for the current page
                // depending on the query arguments this is either
                // the createtion date or the modification date
                // as a unix timestamp. It will also always be in the
                // ts field.
                if (! empty($r['show_date'])) {
                        if ('modified' == $r['show_date'])
                                $page_tree[$page->ID]['ts'] = $page->time_modified;
                        else
                                $page_tree[$page->ID]['ts'] = $page->time_created;
                }

                // The tricky bit!!
                // Using the parent ID of the current page as the
                // array index we set the curent page as a child of that page.
                // We can now start looping over the $page_tree array
                // with any ID which will output the page links from that ID downwards.
                $page_tree[$page->post_parent]['children'][] = $page->ID;
            if( $r['current'] == $page->ID) {
                if($page->post_parent != 0 || $r['show_root'] == true)
                    $parents[] = $page->post_parent;
            }

        }

        $len = count($parents);
        for($i = 0; $i < $len ; $i++) {
            $parent_page_id = $parents[$i];
            $parent_page = $page_tree[$parent_page_id];

            if(isset($parent_page['parent']) && !in_array($parent_page['parent'], $parents)) {
                if($parent_page['parent'] != 0 || $r['show_root'] == true) {
                        $parents[] = $parent_page['parent'];
                        $len += 1;
                        if( $len >= 2 && $r['show_all_parents'] == 0) {
                            break;
                        }

                    }
            }
        }
        $level = 0;

        if( is_array($page_tree[$r['current']]['children']) === true ) {
                foreach( $page_tree[$r['current']]['children'] as $page_id) {
                        $title = $page_tree[$page_id]['title'];
                        $parse .= "<li><a href=\"".get_page_link($page_id)."\" title=\"" .wp_specialchars($title) . "\">$title</a></li>\n";
                }
                $level++;
                $parse = "<ul>$parse</ul>\n";
        }
                $parent = $page_tree[$r['current']]['parent'];
                foreach( $page_tree[$parent]['children'] as $page_id) {
                        $title = $page_tree[$page_id]['title'];
                        if ($page_id == $r['current'])
                                $title = "<b>$title</b>$parse";
                        else
                                $title = "<a href=\"".get_page_link($page_id)."\" title=\"" .wp_specialchars($title) . "\">$title</a>";
                        $parselevel2 .= "<li>$title</li>\n";
                }
                $level++;
                $parse = "<ul>$parselevel2</ul>\n";


                $page_id = $page_tree[$r['current']]['parent'];
                while ($level < $r['maxlevel'] AND $page_id != 0) {
                        $level++;
                        $title = $page_tree[$page_id]['title'];
                        $parse = "<ul><li><a href=\"".get_page_link($page_id)."\" title=\"" .wp_specialchars($title) . "\">$title</a>$parse</li></ul>\n";
                        $page_id = $page_tree[$page_id]['parent'];
                }
                $level++;
                echo $parse;
     }





 
		echo $after_widget;
	}
	register_sidebar_widget('Page Navigation', 'widget_pagenav'); 

}

add_action('widgets_init', 'widget_pagenav_init');

?>
