<?php
if (function_exists('register_sidebar'))
{
	register_sidebar();
}

$themename = "Web2.0*";
$shortname = "web2";
$options = array (	array(	"name" => "General",
							"type" => "heading"),
					array(	"name" => "Body background color",
							"id" => $shortname."_body_bgcolor",
							"type" => "text",
							"std" => "#444444",
							"notes" => ""),
					array(	"name" => "Theme width",
							"id" => $shortname."_th_width",
							"type" => "text",
							"std" => "90%",
							"notes" => " can be specified in '%' or 'px'"),
					array(	"name" => "Content background color",
							"id" => $shortname."_content_bgcolor",
							"type" => "text",
							"std" => "#FFFFFF",
							"notes" => ""),
					array(	"name" => "General font family",
							"id" => $shortname."_cf_font",
							"type" => "select",
							"std" => "Verdana, Arial, Helvetica, sans-serif",
							"options" => array("Verdana, Arial, Helvetica, sans-serif", "Arial, Helvetica, sans-serif", "Georgia, 'Times New Roman', Times, serif"),
							"notes" => ""),
					array(	"name" => "General font color",
							"id" => $shortname."_cf_color",
							"type" => "text",
							"std" => "#000000",
							"notes" => ""),
					array(	"name" => "General link color normal",
							"id" => $shortname."_cl_color",
							"type" => "text",
							"std" => "#0088FF",
							"notes" => ""),
					array(	"name" => "General link color mouse-over",
							"id" => $shortname."_ch_color",
							"type" => "text",
							"std" => "#FF8800",
							"notes" => ""),
					array(	"name" => "General bottom border color",
							"id" => $shortname."_bc_color",
							"type" => "text",
							"std" => "#CCCCCC",
							"notes" => ""),
					array(	"name" => "Alternative bottom border color",
							"id" => $shortname."_ac_color",
							"type" => "text",
							"std" => "#EEEEEE",
							"notes" => ""),
					array(	"name" => "Post meta-data background color",
							"id" => $shortname."_md_color",
							"type" => "text",
							"std" => "#CCFF99",
							"notes" => ""),
					array(	"name" => "Header",
							"type" => "heading"),
					array(	"name" => "Header background color",
							"id" => $shortname."_hd_bgcolor",
							"type" => "text",
							"std" => "#000000",
							"notes" => ""),
					array(	"name" => "Header font family",
							"id" => $shortname."_hf_font",
							"type" => "select",
							"std" => "'Trebuchet MS', Arial, Helvetica, sans-serif",
							"options" => array("'Trebuchet MS', Geneva, Arial, Helvetica, sans-serif", "Arial, Helvetica, sans-serif", "Georgia, 'Times New Roman', Times, serif"),
							"notes" => ""),
					array(	"name" => "Header link color normal",
							"id" => $shortname."_hl_color",
							"type" => "text",
							"std" => "#FF0088",
							"notes" => ""),
					array(	"name" => "Header link color mouse-over",
							"id" => $shortname."_hh_color",
							"type" => "text",
							"std" => "#FFFFFF",
							"notes" => ""),
					array(	"name" => "Header slogan color",
							"id" => $shortname."_hs_color",
							"type" => "text",
							"std" => "#666666",
							"notes" => ""),
					array(	"name" => "Menu",
							"type" => "heading"),
					array(	"name" => "Menu normal background color",
							"id" => $shortname."_menu_bgcolor_1",
							"type" => "text",
							"std" => "#666666",
							"notes" => ""),
					array(	"name" => "Menu mouse-over background color",
							"id" => $shortname."_menu_bgcolor_2",
							"type" => "text",
							"std" => "#505050",
							"notes" => ""),
					array(	"name" => "Menu current background color",
							"id" => $shortname."_menu_bgcolor_3",
							"type" => "text",
							"std" => "#FFFFFF",
							"notes" => ""),
					array(	"name" => "Sub-menu normal background color",
							"id" => $shortname."_menu_bgcolor_4",
							"type" => "text",
							"std" => "#777777",
							"notes" => ""),
					array(	"name" => "Sub-menu mouse-over background color",
							"id" => $shortname."_menu_bgcolor_5",
							"type" => "text",
							"std" => "#777777",
							"notes" => ""),
					array(	"name" => "Sub-menu current background color",
							"id" => $shortname."_menu_bgcolor_6",
							"type" => "text",
							"std" => "#EEEEEE",
							"notes" => ""),
					array(	"name" => "Sub-menu current mouse-over background color",
							"id" => $shortname."_menu_bgcolor_7",
							"type" => "text",
							"std" => "#EEEEEE",
							"notes" => ""),
					array(	"name" => "Menu normal link color",
							"id" => $shortname."_menu_fl_1",
							"type" => "text",
							"std" => "#CCCCCC",
							"notes" => ""),
					array(	"name" => "Menu mouse-over link color",
							"id" => $shortname."_menu_fh_1",
							"type" => "text",
							"std" => "#FFFFFF",
							"notes" => ""),
					array(	"name" => "Menu current link color",
							"id" => $shortname."_menu_fc_1",
							"type" => "text",
							"std" => "#000000",
							"notes" => ""),
					array(	"name" => "Sub-menu normal link color",
							"id" => $shortname."_menu_fl_2",
							"type" => "text",
							"std" => "#CCCCCC",
							"notes" => ""),
					array(	"name" => "Sub-menu mouse-over link color",
							"id" => $shortname."_menu_fh_2",
							"type" => "text",
							"std" => "#FFFFFF",
							"notes" => ""),
					array(	"name" => "Sub-menu current link color",
							"id" => $shortname."_menu_fc_2",
							"type" => "text",
							"std" => "#000000",
							"notes" => ""),
					array(	"name" => "Post Title",
							"type" => "heading"),
					array(	"name" => "Title font family",
							"id" => $shortname."_tf_font",
							"type" => "select",
							"std" => "'Trebuchet MS', Arial, Helvetica, sans-serif",
							"options" => array("'Trebuchet MS', Geneva, Arial, Helvetica, sans-serif", "Arial, Helvetica, sans-serif", "Georgia, 'Times New Roman', Times, serif"),
							"notes" => ""),
					array(	"name" => "Title link color normal",
							"id" => $shortname."_tl_color",
							"type" => "text",
							"std" => "#FF0088",
							"notes" => ""),
					array(	"name" => "Title link color mouse-over",
							"id" => $shortname."_th_color",
							"type" => "text",
							"std" => "#0088FF",
							"notes" => ""),
					array(	"name" => "Comments",
							"type" => "heading"),
					array(	"name" => "Comment alternative background color",
							"id" => $shortname."_cb_color",
							"type" => "text",
							"std" => "#F1F1F1",
							"notes" => ""),
					array(	"name" => "Comment author background color",
							"id" => $shortname."_ca_color",
							"type" => "text",
							"std" => "#FFFFCC",
							"notes" => ""),
					array(	"name" => "Comment form field normal background color",
							"id" => $shortname."_cfb_color",
							"type" => "text",
							"std" => "#EEEEEE",
							"notes" => ""),
					array(	"name" => "Comment form field focused background color",
							"id" => $shortname."_cff_color",
							"type" => "text",
							"std" => "#CCFFFF",
							"notes" => ""),
					array(	"name" => "Code Display",
							"type" => "heading"),
					array(	"name" => "Code font color",
							"id" => $shortname."_cd_color",
							"type" => "text",
							"std" => "#FFFFFF",
							"notes" => ""),
					array(	"name" => "Code background color",
							"id" => $shortname."_cd_bgcolor",
							"type" => "text",
							"std" => "#000000",
							"notes" => ""),
					array(	"name" => "Footer",
							"type" => "heading"),
					array(	"name" => "Footer background color",
							"id" => $shortname."_fb_bgcolor",
							"type" => "text",
							"std" => "#000000",
							"notes" => ""),
					array(	"name" => "Footer font color",
							"id" => $shortname."_fc_color",
							"type" => "text",
							"std" => "#FFFFFF",
							"notes" => ""),
					array(	"name" => "Footer link color normal",
							"id" => $shortname."_fl_color",
							"type" => "text",
							"std" => "#FF0088",
							"notes" => ""),
					array(	"name" => "Footer link color mouse-over",
							"id" => $shortname."_fh_color",
							"type" => "text",
							"std" => "#0088FF",
							"notes" => "") );

function mytheme_add_admin()
{
	global $themename, $shortname, $options;
	if ($_GET['page'] == basename(__FILE__))
	{
		if ('save' == $_REQUEST['action'])
		{
			foreach ($options as $value)
			{
				update_option($value['id'], $_REQUEST[$value['id']]);
			}
			foreach ($options as $value)
			{
				if (isset($_REQUEST[$value['id']]))
				{
					update_option($value['id'], $_REQUEST[$value['id']]);
				}
				else
				{
					delete_option($value['id']);
				}
			}
			header("Location: themes.php?page=functions.php&saved=true");
			die;
		}
		else if ('reset' == $_REQUEST['action'])
		{
			foreach ($options as $value)
			{
				delete_option($value['id']);
			}
			header("Location: themes.php?page=functions.php&reset=true");
			die;
		}
	}
	add_theme_page($themename." Options", $themename." Options", 'edit_themes', basename(__FILE__), 'mytheme_admin');
}

function mytheme_admin()
{
	global $themename, $shortname, $options;
	if ($_REQUEST['saved']) echo '<div id="message" class="updated fade"><p><strong>'.$themename.' settings saved.</strong></p></div>';
	if ($_REQUEST['reset']) echo '<div id="message" class="updated fade"><p><strong>'.$themename.' settings reset.</strong></p></div>';
	?>
<div class="wrap">
	<h2><?php echo $themename; ?> settings</h2>
	<p>This page will allow you to make simple modifications to the <?php echo $themename; ?> theme's settings. If you need color-scheme inspiration then visit <a href="http://beta.dailycolorscheme.com/" target="_blank">Daily Color Scheme</a>.</p>
	<p>Tip: A good way to get color values is to use <a href="http://www.mozilla.com/firefox/" target="_blank">Firefox</a> browser and <a href="https://addons.mozilla.org/en-US/firefox/addon/271" target="_blank">ColorZilla</a> extension.</p>
	<form method="post" style="margin-top:1em;">
		<table class="optiontable" style="font-size:90%;">
			<?php
			foreach ($options as $value)
			{
				if ($value['type'] == "heading")
				{
					?>
			<tr>
				<td colspan="2"><h3 style="border-bottom:3px solid #ccc;margin-bottom:0;"><?php echo $value['name']; ?></h3></th>
			</tr>
					<?php
				}
				elseif ($value['type'] == "text")
				{
					?>
			<tr>
				<th scope="row"><?php echo $value['name']; ?>:</th>
				<td>
				<input name="<?php echo $value['id']; ?>" id="<?php echo $value['id']; ?>" type="<?php echo $value['type']; ?>" value="<?php if (get_settings($value['id']) != "") { echo get_settings($value['id']); } else { echo $value['std']; } ?>" />
				<?php echo $value['notes']; ?>
				</td>
			</tr>
					<?php
				}
				elseif ($value['type'] == "select")
				{
					?>
			<tr>
				<th scope="row"><?php echo $value['name']; ?>:</th>
				<td>
				<select name="<?php echo $value['id']; ?>" id="<?php echo $value['id']; ?>">
					<?php foreach ($value['options'] as $option) { ?>
					<option<?php if (get_settings($value['id']) == $option) { echo ' selected="selected"'; } elseif ($option == $value['std']) { echo ' selected="selected"'; } ?>><?php echo $option; ?></option>
					<?php } ?>
				</select>
				<?php echo $value['notes']; ?>
				</td>
			</tr>
					<?php 
				}
			}
			?>
		</table>
		<p class="submit">
		<input name="save" type="submit" value="Save changes" />
		<input type="hidden" name="action" value="save" />
		</p>
	</form>
	<form method="post">
		<p class="submit" style="float:right;margin-top:1.75em;">
		<input name="reset" type="submit" value="Reset" />
		<input type="hidden" name="action" value="reset" />
		</p>
	</form>
	<p style="border-top:3px solid #ccc;margin-top:2em;padding-top:1em;">Made a mess of things and wish to reset the <?php echo $themename; ?> theme's settings to it's defaults? No problem, simply click the 'Reset' button below.</p>
	<?php
}

function mytheme_wp_head()
{
	?>
	<link href="<?php bloginfo('template_directory'); ?>/style.php" rel="stylesheet" type="text/css" />
	<?php
}

add_action('wp_head', 'mytheme_wp_head');
add_action('admin_menu', 'mytheme_add_admin');

?>