<?php	// Do not delete these lines
if ('comments.php' == basename($_SERVER['SCRIPT_FILENAME']))
{
	die ('Please do not load this page directly. Thanks!');
}
if (!empty($post->post_password))
{
	// if there's a password
	if ($_COOKIE['wp-postpass_' . COOKIEHASH] != $post->post_password)
	{
		// and it doesn't match the cookie
		?>
<p class="nocomments"><?php _e("This post is password protected. Enter the password to view comments."); ?></p>
		<?php
		return;
	}
}
?>

<div id="commentblock">
	
	<h2 id="comments"><?php comments_number(__('No Comments'), __('1 Comment so far'), __('% Comments so far')); ?></h2>
	
	<ol class="commentlist" id="commentlist">
	
	<?php if ($comments) : ?>
	
		<?php foreach ($comments as $comment) : ?>

			<?php
			$isByAuthor = false;
			if ($comment->comment_author_email == get_the_author_email())
			{
				$isByAuthor = true;
			}
			if ('comment-entry-alt' == $oddcomment && $isByAuthor == true)
			{
				$oddcomment = 'comment-entry-owner';
			}
			if ('comment-entry-alt' != $oddcomment && $isByAuthor == true)
			{
				$oddcomment = 'comment-entry-owner';
			}
			elseif ('comment-entry-alt' == $oddcomment && $isByAuthor == false)
			{
				$oddcomment = 'comment-entry';
			}
			else
			{
				$oddcomment = 'comment-entry-alt';
			}
			?>

		<li id="comment-<?php comment_ID(); ?>" class="<?php _e($oddcomment); ?>">
		<div class="comment-entry-meta">
			<p><?php _e('on'); ?> <em><?php comment_date(); ?></em> <?php _e('at'); ?> <?php comment_time(); ?> <strong><?php comment_author_link() ?></strong> <?php _e('wrote'); ?>:</p>
		</div>
		<div class="comment-text">
			<?php comment_text();?>
		</div>
		<?php if ($comment->comment_approved == '0') : ?>
		<div class="comment-unapproved"><?php _e('Your comment has been submitted. It is now awaiting approval.'); ?></div>
		<?php endif; ?>
		</li>
		
		<?php endforeach; /* end for each comment */ ?>
	
	</ol>

	<?php else : // this is displayed if there are no comments so far ?>

		<?php if ('open' == $post->comment_status) : ?>
		
		<li id="hidelist" style="display:none;"></li>

	</ol>

	<h3 id="nocomment"><?php _e('Be the first to comment on this entry.'); ?></h3>

	<?php else : // comments are closed ?>
	
		<li style="display:none"></li>
	
	</ol>

	<p><?php _e('Comments are closed.'); ?></p>

	<?php endif; ?>

<?php endif; ?>

<div id="loading" style="display:none;"><?php _e('Posting your comment&hellip;'); ?></div>
<div id="errors" style="display:none;"></div>

<?php if ('open' == $post-> comment_status) : ?>

	<div id="comments-form">
	
		<a name="respond"></a><h3><?php _e('Have your say'); ?></h3>
		
		<?php if (get_option('comment_registration') && !$user_ID ) : ?>

		<p id="comments-blocked"><?php _e('You must be'); ?> <a href="<?php echo get_option('siteurl'); ?>/wp-login.php?redirect_to=<?php the_permalink(); ?>"><?php _e('logged in'); ?></a> <?php _e('to post a comment.'); ?></p>

	</div>
		<?php else : ?>

		<form action="<?php echo get_option('siteurl'); ?>/wp-comments-post.php" id="commentform" method="post" onsubmit="new Ajax.Updater({success: 'commentlist'}, '<?php bloginfo('stylesheet_directory') ?>/comments-ajax.php', {asynchronous: true, evalScripts: true, insertion: Insertion.Bottom, onComplete: function(request){complete(request)}, onFailure: function(request){failure(request)}, onLoading: function(request){loading()}, parameters: Form.serialize(this)}); return false;">

			<?php if ($user_ID) : ?>
	
			<p>Logged in as <a href="<?php echo get_option('siteurl'); ?>/wp-admin/profile.php"><?php echo $user_identity; ?></a>. <a href="<?php echo get_option('siteurl'); ?>/wp-login.php?action=logout" title="Log out of this account">Logout</a></p>

			<?php else : ?>
	
			<p><label for="author"><?php _e('<strong>Name</strong>'); ?><?php if ($req) _e(' (required)'); ?></label>
			<input type="text" name="author" id="author" value="<?php echo $comment_author; ?>" size="22" /></p>
			
			<p><label for="email"><?php _e('<strong>E-mail</strong> (will not be published)'); ?><?php if ($req) _e(' (required)'); ?></label>
			<input type="text" name="email" id="email" value="<?php echo $comment_author_email; ?>" size="22" /></p>
			
			<p><label for="url"><?php _e('Website'); ?></label>
			<input type="text" name="url" id="url" value="<?php echo $comment_author_url; ?>" size="22" /></p>

			<?php endif; ?>

			<p><textarea name="comment" id="comment" rows="15" cols="30"></textarea></p>
		
			<p><input type="submit" id="submit" name="submit" value="Post Comment" class="button" />
			<input type="hidden" name="comment_post_ID" value="<?php echo $id; ?>" /></p>
			<?php do_action('comment_form', $post->ID); ?>

		</form>
		<div id="comments-guidelines">
			<?php if ($user_ID) : ?>
			<p><?php _e('Logged in as'); ?> <a href="<?php echo get_option('siteurl'); ?>/wp-admin/profile.php" title="Logged in as <?php echo $user_identity; ?>"><?php echo $user_identity; ?></a>. <a href="<?php echo get_option('siteurl'); ?>/wp-login.php?action=logout" title="Log out of this account"><?php _e('Logout &raquo;'); ?></a></p>
			<?php else : ?>
			<div id="comments-guidelines-info">
				<p><?php _e('Fields in'); ?> <strong style="color:#000;"><?php _e('bold');?></strong> <?php _e('are required. Email addresses are'); ?> <strong><?php _e('never'); ?></strong> <?php _e('published or distributed.'); ?></p>
				<p><?php _e('Some HTML code is allowed:'); ?><br /><code><?php echo allowed_tags(); ?></code><br /><?php _e('URIs must be fully qualified'); ?> (eg: <strong>http://</strong>www.domainname.com) <?php _e('and all tags must be properly closed.'); ?></p>
				<p><?php _e('Line breaks and paragraphs are automatically converted.'); ?></p>
				<p><?php _e('Please keep comments relevant. Off-topic, offensive or inappropriate comments'); ?> <em><?php _e('may'); ?></em> <?php _e('be edited or removed.'); ?></p>
			</div>
			<?php endif; ?>
		</div>
	</div>
		
		<?php endif; // If registration required and not logged in ?>

<?php endif; // if you delete this the sky will fall on your head ?>

</div>